//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "installedversionplugin.h"

#include <packagenotfoundexception.h>

#include "package.h"
#include "ipackagedb.h"

namespace NPlugin {

InstalledVersionPlugin::InstalledVersionPlugin(NApt::IPackageDB* pPackageDB) :
	_title(tr("Installed Version Plugin")),
	_briefDescription(tr("Shows the version of the installed package in the package list")),
	_description(tr("Shows the version of the installed package in the package list")),
	_pPackageDB(pPackageDB)
{
}


InstalledVersionPlugin::~InstalledVersionPlugin()
{
}


/////////////////////////////////////////////////////
// Plugin Interface
/////////////////////////////////////////////////////
 
void InstalledVersionPlugin::init(IProvider* pProvider)
{
}

/////////////////////////////////////////////////////
// ShortInformationPlugin Interface
/////////////////////////////////////////////////////

const QString InstalledVersionPlugin::shortInformationText(int packageID)
{
	try 
	{
		return QString(_pPackageDB->getPackageRecord(packageID).installedVersion);
	}
	catch (const PackageNotFoundException& e)
	{
		return _emptyString;
	}
}

/////////////////////////////////////////////////////
// InstalledVersionPlugin functions
/////////////////////////////////////////////////////


};
