#!/usr/bin/python
from __future__ import print_function

from re import compile,DOTALL,MULTILINE
import sys

enum = compile("static const PkEnumMatch enum_([^\]]+)\[\] = {(.*?)};", DOTALL|MULTILINE)
value = compile("PK_([A-Z_]+)_ENUM_([A-Z0-9_]+),\s+\"([^\"]+)\"")

inp = open(sys.argv[1]).read()

names = {}

print("# This file was autogenerated from %s by enum-converter.py\n" % sys.argv[1])
print("class PackageKitEnum:")
for (name,data) in enum.findall(inp):
	print("\t%s = ("%name, end=' ')
	for (type,enum,string) in value.findall(data):
		print("\"%s\","%string, end=' ')
		names["%s_%s"%(type,enum)] = string
	print(")")

print("\n# Constants\n")

for k in sorted(names.keys()):
	print('%s = "%s"'%(k,names[k]))

