/* Copyright (C) 2004 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

/**
 * @file myx_gc_gl_helper.h 
 * @brief Helper functions for creating OpenGL data and structures out of XML data.
 * 
 */

#ifndef __GC_GL_HELPER_H__
#define __GC_GL_HELPER_H__

#include "myx_gc.h"
#include <libxml/xmlmemory.h>

#include "myx_gc_datatypes.h"

// Adds colors to the named color table.
void RegisterSystemColors(const TColorMap &ColorMap);

// Find a color by name.
bool ColorByName(string Name, GLubyte* Color);

// Reads the attribute with the given name (if it exists) and converts it to a float value.
bool GetFloatAttribute(xmlNodePtr Element, const char* Name, float& Value);

// Like GetFloatAttribute but with a default value in case the attribute does not exist.
float GetFloatAttributeDef(xmlNodePtr Element, const char* Name, float Default);

// Reads the attribute with the given name (if it exists) and converts it to an integer value.
bool GetIntAttribute(xmlNodePtr Element, const char* Name, int& Value);

// Like GetIntAttribute but with a default value in case the attribute does not exist.
int GetIntAttributeDef(xmlNodePtr Element, const char* Name, int Default);

// Reads the attribute with the given name (if it exists) and returns it.
bool GetStringAttribute(xmlNodePtr Element, const char* Name, string& Value);

// Like GetStringAttribute but with a default value in case the attribute does not exist.
string GetStringAttributeDef(xmlNodePtr Element, const char* Name, const string Default);

// Reads the attribute with the given name and treats it as color value.
int ConvertColor(xmlNodePtr Element, const char* Name, GLubyte* Color);

// Parses the given XML element for a texture definition.
void ParseTextureEntry(xmlNodePtr XML);

// Parses the given XML element for a texture definition.
void ParseTextureEntry(xmlNodePtr XML);

#endif // __GC_GL_HELPER_H__

