// test_backup_profile.cpp : Defines the entry point for the console application.
//

#include "stdio.h"
#include "stdlib.h"
#include "myx_admin_public_interface.h"

char * filename_in= "in.xml";
char * filename_out= "out.xml";

void print_usage()
{
  printf("usage : test_admin_xml.exe "
         "[backup_profile|gui_description <version> <platform>]\n");
}

int main(int argc, char *argv[])
{
  MYX_ADMIN_LIB_ERROR err;

  if (argc<2)
  {
    print_usage();
  }
  else if (!strcmp(argv[1],"backup_profile"))
  {
    MYX_BACKUP_PROFILE * profile= myx_load_profile(filename_in,"",&err);
    myx_save_profile(filename_out,"",profile);
    myx_free_profile(profile);
  }
  else if (!strcmp(argv[1],"gui_description"))
  {
    if (argc<4)
    {
      print_usage();
    }
    else
    {
      const char * version= argv[2];
      MYX_PLATFORM platform= (MYX_PLATFORM)atoi(argv[3]);
      MYX_ADMIN_LIB_ERROR error_code;
      MYX_GUI_DESCRIPTION * description=
                             myx_get_gui_description(filename_in,version,
                                                     platform,&error_code,0,0);
      myx_free_gui_description(description);
    }
  }
  return 0;
}

