// fader.C

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/

#ifdef __GNUG__
#pragma implementation
#endif

#include "localdefs.h"
#include "fader.h"
#include "envelope.h"
#include "curvegen.h"
#include "valuerequester.h"

enum { FadeLinear = 1, FadeDecibel = 2 };

ChoiceValue Fader::_savedCurveType = FadeLinear;

Fader::Fader(Data *output, Direction theDirection)
	: Phraser(output, new Envelope(8192)),
	  _direction(theDirection), _curveType(_savedCurveType) {
	setGain(1.0);
}

Requester *
Fader::createRequester() {
	return new ChoiceRequester(
		_direction == FadeIn ? "Fade In Selected Region:" : "Fade Out Selected Region:",
		"Curve Type:",
		"|Linear in Gain|Linear in dB|",
		_curveType
	);
}

void
Fader::initialize() {
	double startVal, endVal;
	if (_curveType == FadeLinear) {
		if (_direction == FadeIn) {
			startVal = 0.0;
			endVal = 1.0;
		}
		else {
			startVal = 1.0;
			endVal = 0.0;
		}
		LinearCurveGenerator gen(envelope, startVal, endVal);
		envelope->apply(gen);
	}
	else {
		double expon = (_direction == FadeIn) ? .5 : 2.0;
		startVal = 0.0;
		endVal = 1.0;
		ExponentialCurveGenerator gen(envelope, startVal, endVal, expon);
		envelope->apply(gen);
		if (_direction == FadeOut)
			envelope->reverse();
	}
	Super::initialize();
}

void
Fader::saveConfig() {
    _savedCurveType = _curveType;	// store value
}
