// datatype.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/

#ifndef DATATYPE_H
#ifdef __GNUG__
#pragma interface
#endif
#define DATATYPE_H

#include "defs.h"

class DataType {
public:
	enum Type {
		Unknown = 0,
		Linear8, Unsigned8,
		ALaw, ULaw,
		Linear16, Linear32,
		FloatingPoint, DoublePrecision
	};
	DataType(int);
	DataType(Type type=Unknown) : typeIndex(type) {}
	DataType(const DataType& dt) : typeIndex(dt.typeIndex) {}
	const DataType& operator = (const DataType& rhs);
	boolean isA(Type type) const;
	short bits() const;
	short bytes() const;
	int formatForHeader() const;
	const char* name() const;
	operator int ();
private:
	struct TypeInfo {
		short bits;
		short bytes;
		int format;
		const char* name;
	};
	static const TypeInfo typeInfo[];
	short typeIndex;
	friend boolean operator == (const DataType&, const DataType&);
	friend boolean operator != (const DataType&, const DataType&);
	friend boolean operator > (const DataType&, const DataType&);
	friend boolean operator >= (const DataType&, const DataType&);
	friend boolean operator < (const DataType&, const DataType&);
	friend boolean operator <= (const DataType&, const DataType&);
};

inline const DataType& DataType::operator = (const DataType& rhs) {
	typeIndex = rhs.typeIndex;
	return *this;
}

inline boolean DataType::isA(DataType::Type type) const {
	return typeIndex == type;
}

inline short DataType::bits() const { return typeInfo[typeIndex].bits; }

inline short DataType::bytes() const { return typeInfo[typeIndex].bytes; }

inline int DataType::formatForHeader() const {
	return typeInfo[typeIndex].format;
}

inline const char* DataType::name() const { return typeInfo[typeIndex].name; }

// friend functions

inline boolean operator == (const DataType& lhs, const DataType& rhs) {
	return lhs.typeIndex == rhs.typeIndex;
}

inline boolean operator != (const DataType& lhs, const DataType& rhs) {
	return lhs.typeIndex != rhs.typeIndex;
}

inline boolean operator > (const DataType& lhs, const DataType& rhs) {
	return lhs.typeIndex > rhs.typeIndex;
}

inline boolean operator >= (const DataType& lhs, const DataType& rhs) {
	return lhs.typeIndex >= rhs.typeIndex;
}

inline boolean operator < (const DataType& lhs, const DataType& rhs) {
	return lhs.typeIndex < rhs.typeIndex;
}

inline boolean operator <= (const DataType& lhs, const DataType& rhs) {
	return lhs.typeIndex <= rhs.typeIndex;
}

#endif

