/*
 *   mwmslash.c -- Mwave Modem AT Command Parser
 *
 *  Written By: Paul Schroeder IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                                           
 * 
 *  10/23/2000 - Alpha Release 0.1.0
 *            First release to the public
 *
 */
#include "mwmparse.h"
#include "mwmparsi.h"
#include "mnpitcb.h"
#include "stddef.h"

static char szThisFile[] = "MWMSLASH.C";




/*****************************************************************************/
/* mwmSlashCommand                                                           */
/*****************************************************************************/
/* This routine is called when a backslash is encountered in the command     */
/* string.                                                                   */
/*                                                                           */
/* Here, we simply look at the next command character and call the           */
/* appropriate Slash command routine.                                        */
/*****************************************************************************/
USHORT mwmSlashCommand(STATEINFO *psi)
{

  USHORT  usParserStatus = 0;
  USHORT  usParm = 0;
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmslash::mwmSlashCommand entry\n");
  /***************************************************************************/
  /* Look at this character in AT Command.                                   */
  /* Then advance index to point to next character.                          */
  /***************************************************************************/
  switch(psi->achCommandBuffer[psi->usNextATIndex++])
  {
    case 'A' :
      /***********************************************************************/
      /* This is a Slash A command...fill the PP command.                    */
      /***********************************************************************/
      /* If the PP results of this command will fit into the buffer.         */
      /***********************************************************************/
      if ( (psi->usNextPPIndex + PP_SLASH_A_CMD_SPACE) < PP_BUFFER_THRESHOLD)
      {
        /*********************************************************************/
        /* Get the parameter from the command string                         */
        /*********************************************************************/
        usParm = mwmParseGetArgFromATString(psi->achCommandBuffer,
                                       &psi->usNextATIndex);

        usParserStatus = mwmSlashACommand(psi,usParm);

      }
      else
      {
        /*********************************************************************/
        /* There is not enough room left in this PP Command buffer to        */
        /* process this command....                                          */
        /*********************************************************************/
        usParserStatus = MWM_GET_MORE_BUFFERS;
        psi->usCurrentCommand = MWM_CONTINUE_AT_BUFFER;
      }
      break;
    case 'B' :
      /***********************************************************************/
      /* This is a Slash B command...                                        */
      /***********************************************************************/
      /* If the PP results of this command will fit into the buffer.         */
      /***********************************************************************/
      if ( (psi->usNextPPIndex + PP_SLASH_B_CMD_SPACE) < PP_BUFFER_THRESHOLD)
      {
        psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x1a | psi->usParserMode);

      }
      else
      {
        /*********************************************************************/
        /* There is not enough room left in this PP Command buffer to        */
        /* process this command....                                          */
        /*********************************************************************/
        usParserStatus = MWM_GET_MORE_BUFFERS;
        psi->usCurrentCommand = MWM_CONTINUE_AT_BUFFER;
      }
      break;
    case 'K' :
      /***********************************************************************/
      /* This is a Slash K command...                                        */
      /***********************************************************************/
      /* If the PP results of this command will fit into the buffer.         */
      /***********************************************************************/
      if ( (psi->usNextPPIndex + PP_SLASH_K_CMD_SPACE) < PP_BUFFER_THRESHOLD)
      {
        /*********************************************************************/
        /* Get the parameter from the command string                         */
        /*********************************************************************/
        usParm = mwmParseGetArgFromATString(psi->achCommandBuffer,
                                       &psi->usNextATIndex);

        usParserStatus = mwmSlashKCommand(psi,usParm);
      }
      else
      {
        /*********************************************************************/
        /* There is not enough room left in this PP Command buffer to        */
        /* process this command....                                          */
        /*********************************************************************/
        usParserStatus = MWM_GET_MORE_BUFFERS;
        psi->usCurrentCommand = MWM_CONTINUE_AT_BUFFER;
      }
      break;
    case 'L' :
      /***********************************************************************/
      /* This is a Slash L command...                                        */
      /***********************************************************************/
      /* If the PP results of this command will fit into the buffer.         */
      /***********************************************************************/
      if ( (psi->usNextPPIndex + PP_SLASH_L_CMD_SPACE) < PP_BUFFER_THRESHOLD)
      {
        /*********************************************************************/
        /* Get the parameter from the command string                         */
        /*********************************************************************/
        usParm = mwmParseGetArgFromATString(psi->achCommandBuffer,
                                       &psi->usNextATIndex);

        usParserStatus = mwmSlashLCommand(psi,usParm);
      }
      else
      {
        /*********************************************************************/
        /* There is not enough room left in this PP Command buffer to        */
        /* process this command....                                          */
        /*********************************************************************/
        usParserStatus = MWM_GET_MORE_BUFFERS;
        psi->usCurrentCommand = MWM_CONTINUE_AT_BUFFER;
      }
      break;
    case 'N' :
      /***********************************************************************/
      /* This is a Slash N command...                                        */
      /***********************************************************************/
      /* If the PP results of this command will fit into the buffer.         */
      /***********************************************************************/
      if ( (psi->usNextPPIndex + PP_SLASH_N_CMD_SPACE) < PP_BUFFER_THRESHOLD)
      {
        /*********************************************************************/
        /* Get the parameter from the command string                         */
        /*********************************************************************/
        usParm = mwmParseGetArgFromATString(psi->achCommandBuffer,
                                       &psi->usNextATIndex);

        usParserStatus = mwmSlashNCommand(psi,usParm);
      }
      else
      {
        /*********************************************************************/
        /* There is not enough room left in this PP Command buffer to        */
        /* process this command....                                          */
        /*********************************************************************/
        usParserStatus = MWM_GET_MORE_BUFFERS;
        psi->usCurrentCommand = MWM_CONTINUE_AT_BUFFER;
      }
      break;
    case 'O' :
      /***********************************************************************/
      /* This is a Slash O command...                                        */
      /***********************************************************************/
      /* If the PP results of this command will fit into the buffer.         */
      /***********************************************************************/
      if ( (psi->usNextPPIndex + PP_SLASH_O_CMD_SPACE) < PP_BUFFER_THRESHOLD)
      {
        psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x1e | psi->usParserMode);
        usParserStatus = MWM_NO_MORE_COMMANDS;
      }
      else
      {
        /*********************************************************************/
        /* There is not enough room left in this PP Command buffer to        */
        /* process this command....                                          */
        /*********************************************************************/
        usParserStatus = MWM_GET_MORE_BUFFERS;
        psi->usCurrentCommand = MWM_CONTINUE_AT_BUFFER;
      }
      break;
    case 'Q' :
      /***********************************************************************/
      /* MTS 3017                                                            */
      /* This is a Slash Q command...                                        */
      /***********************************************************************/
      /* If the PP results of this command will fit into the buffer.         */
      /***********************************************************************/
      if ( (psi->usNextPPIndex + PP_SLASH_T_CMD_SPACE) < PP_BUFFER_THRESHOLD)
      {
        /*********************************************************************/
        /* Get the parameter from the command string                         */
        /*********************************************************************/
        usParm = mwmParseGetArgFromATString(psi->achCommandBuffer,
                                       &psi->usNextATIndex);

        usParserStatus = mwmSlashQCommand(psi,usParm);
      }
      else
      {
        /*********************************************************************/
        /* There is not enough room left in this PP Command buffer to        */
        /* process this command....                                          */
        /*********************************************************************/
        usParserStatus = MWM_GET_MORE_BUFFERS;
        psi->usCurrentCommand = MWM_CONTINUE_AT_BUFFER;
      }
      break;
    case 'T' :
      /***********************************************************************/
      /* This is a Slash T command...                                        */
      /***********************************************************************/
      /* If the PP results of this command will fit into the buffer.         */
      /***********************************************************************/
      if ( (psi->usNextPPIndex + PP_SLASH_T_CMD_SPACE) < PP_BUFFER_THRESHOLD)
      {
        /*********************************************************************/
        /* Get the parameter from the command string                         */
        /*********************************************************************/
        usParm = mwmParseGetArgFromATString(psi->achCommandBuffer,
                                       &psi->usNextATIndex);

        usParserStatus = mwmSlashTCommand(psi,usParm);
      }
      else
      {
        /*********************************************************************/
        /* There is not enough room left in this PP Command buffer to        */
        /* process this command....                                          */
        /*********************************************************************/
        usParserStatus = MWM_GET_MORE_BUFFERS;
        psi->usCurrentCommand = MWM_CONTINUE_AT_BUFFER;
      }
      break;
    case 'U' :
      /***********************************************************************/
      /* This is a Slash U command...                                        */
      /***********************************************************************/
      /* If the PP results of this command will fit into the buffer.         */
      /***********************************************************************/
      if ( (psi->usNextPPIndex + PP_SLASH_U_CMD_SPACE) < PP_BUFFER_THRESHOLD)
      {
        psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x20 | psi->usParserMode);
        usParserStatus = MWM_NO_MORE_COMMANDS;
      }
      else
      {
        /*********************************************************************/
        /* There is not enough room left in this PP Command buffer to        */
        /* process this command....                                          */
        /*********************************************************************/
        usParserStatus = MWM_GET_MORE_BUFFERS;
        psi->usCurrentCommand = MWM_CONTINUE_AT_BUFFER;
      }
      break;
    case 'V' :
      /***********************************************************************/
      /* This is a Slash V command...                                        */
      /***********************************************************************/
      /* If the PP results of this command will fit into the buffer.         */
      /***********************************************************************/
      if ( (psi->usNextPPIndex + PP_SLASH_V_CMD_SPACE) < PP_BUFFER_THRESHOLD)
      {
        /*********************************************************************/
        /* Get the parameter from the command string                         */
        /*********************************************************************/
        usParm = mwmParseGetArgFromATString(psi->achCommandBuffer,
                                       &psi->usNextATIndex);

        usParserStatus = mwmSlashVCommand(psi,usParm);
      }
      else
      {
        /*********************************************************************/
        /* There is not enough room left in this PP Command buffer to        */
        /* process this command....                                          */
        /*********************************************************************/
        usParserStatus = MWM_GET_MORE_BUFFERS;
        psi->usCurrentCommand = MWM_CONTINUE_AT_BUFFER;
      }
      break;
    case 'Y' :
      /***********************************************************************/
      /* This is a Slash Y command...                                        */
      /***********************************************************************/
      /* If the PP results of this command will fit into the buffer.         */
      /***********************************************************************/
      if ( (psi->usNextPPIndex + PP_SLASH_U_CMD_SPACE) < PP_BUFFER_THRESHOLD)
      {
        psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x21 | psi->usParserMode);
        usParserStatus = MWM_NO_MORE_COMMANDS;
      }
      else
      {
        /*********************************************************************/
        /* There is not enough room left in this PP Command buffer to        */
        /* process this command....                                          */
        /*********************************************************************/
        usParserStatus = MWM_GET_MORE_BUFFERS;
        psi->usCurrentCommand = MWM_CONTINUE_AT_BUFFER;
      }
      break;
    case 'Z' :
      /***********************************************************************/
      /* This is a Slash Z command...                                        */
      /***********************************************************************/
      /* If the PP results of this command will fit into the buffer.         */
      /***********************************************************************/
      if ( (psi->usNextPPIndex + PP_SLASH_Z_CMD_SPACE) < PP_BUFFER_THRESHOLD)
      {
        /*********************************************************************/
        /* Get the parameter from the command string                         */
        /*********************************************************************/
        usParm = mwmParseGetArgFromATString(psi->achCommandBuffer,
                                       &psi->usNextATIndex);

        usParserStatus = mwmSlashZCommand(psi,usParm);
      }
      else
      {
        /*********************************************************************/
        /* There is not enough room left in this PP Command buffer to        */
        /* process this command....                                          */
        /*********************************************************************/
        usParserStatus = MWM_GET_MORE_BUFFERS;
        psi->usCurrentCommand = MWM_CONTINUE_AT_BUFFER;
      }
      break;

    case '\0':
      break;

    default:
      usParserStatus = MWM_ATCMD_ERROR;
  }

  if (usParserStatus & MWM_GET_MORE_BUFFERS)
    /*************************************************************************/
    /* Move the AT Command Index back to this command to be parsed           */
    /* on the next interrupt.                                                */
    /*************************************************************************/
    psi->usNextATIndex--;
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmslash::mwmSlashCommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}





/*****************************************************************************/
/* mwmSlashACommand                                                          */
/*****************************************************************************/
/* Called by...                                                              */
/*   mwmSlashCommand when...                                                 */
/*   Slash A command is encountered in the AT command string.                */
/*                                                                           */
/*   mwmParseInitializeModem when...                                         */
/*   The modem is initialized, either at startup, or when a profile is       */
/*   being loaded into the modem.                                            */
/*                                                                           */
/* The check for buffer full should take place before calling this routine.  */
/*****************************************************************************/
USHORT  mwmSlashACommand(STATEINFO *psi, USHORT usSlashAParm)

{
  USHORT usParserStatus = 0;
  USHORT usAPAflag = 0;
  USHORT usN402Value = 0;
  REGISTERS Registers;
  ULONG  ulRC = 0;
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmslash::mwmSlashACommand entry\n");
  switch(usSlashAParm)
  {
    case 0:
      usN402Value = 0x40;
      break;
    case 1:
      usN402Value = 0x80;
      break;
    case 2:
      usN402Value = 0xc0;
      break;
    case 3:
      usN402Value = 0x100;
      break;
    case 4:
      usN402Value = 0x100;
      usAPAflag = 0xffff;
      break;
    default:
     usParserStatus= usParserStatus | MWM_ATCMD_ERROR;
  }

  if (!usParserStatus)
  {
    /*************************************************************************/
    /* add the PP command for Slash A to the PP command string.              */
    /*************************************************************************/
//    psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x19 | psi->usParserMode);

    /*************************************************************************/
    /* Add the N402 Parameter.                                               */
    /*************************************************************************/
//    psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usN402Value;

    /*************************************************************************/
    /* Add the APA Parameter.                                                */
    /*************************************************************************/
//    psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usAPAflag;

    /*************************************************************************/
    /* Add the parameter to the end of the PP command string.                */
    /*************************************************************************/
//    psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usSlashAParm;

    /*************************************************************************/
    /* Update Register                                                       */
    /*************************************************************************/
    mwmParseQueryModemRegisters(&Registers);
    Registers.SlashA = usSlashAParm;
    mwmParseSetModemRegisters(&Registers);

//  DPF("Writing 0x%x to MNPITCB.RN402 (0x%04x)",usN402Value,((psi->dsp.dspaddrMNPITCB)+ offsetof(MNPITCB, RN402)));
    /*************************************************************************/
    /* Set MNPITCB.RN402 to the parameter.                                   */
    /*************************************************************************/
    ulRC = dspMemTransfer(psi->dsp.hDSP, (psi->dsp.dspaddrMNPITCB)+ offsetof(MNPITCB, RN402),
                          &usN402Value, 1,
                          DSP_MEMXFER_DATA_WRITE);
    if (ulRC!=DSP_NOERROR)
    {
      mwmIPCHandleError(szThisFile,__LINE__,&psi->mwmError,
                        MWM_DSP_ERROR, ulRC );
      return (USHORT)ulRC;
    }

//  DPF("Writing 0x%x to MNPITCB.RAPA (0x%04x)",usAPAflag,((psi->dsp.dspaddrMNPITCB)+ offsetof(MNPITCB, RAPA)));
    /*************************************************************************/
    /* Set MNPITCB.RAPA to the parameter.                                    */
    /*************************************************************************/
    ulRC = dspMemTransfer(psi->dsp.hDSP, (psi->dsp.dspaddrMNPITCB)+ offsetof(MNPITCB, RAPA),
                          &usAPAflag, 1,
                          DSP_MEMXFER_DATA_WRITE);
    if (ulRC!=DSP_NOERROR)
    {
      mwmIPCHandleError(szThisFile,__LINE__,&psi->mwmError,
                        MWM_DSP_ERROR, ulRC );
      return (USHORT)ulRC;
    }
  }
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmslash::mwmSlashACommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}





/*****************************************************************************/
/* mwmSlashKCommand                                                          */
/*****************************************************************************/
/* Called by...                                                              */
/*   mwmSlashCommand when...                                                 */
/*   Slash K command is encountered in the AT command string.                */
/*                                                                           */
/*   mwmParseInitializeModem when...                                         */
/*   The modem is initialized, either at startup, or when a profile is       */
/*   being loaded into the modem.                                            */
/*                                                                           */
/* The check for buffer full should take place before calling this routine.  */
/*****************************************************************************/
USHORT  mwmSlashKCommand(STATEINFO *psi, USHORT usSlashKParm)
{
  USHORT usParserStatus = 0;
  USHORT usLNMODEValue = 0;
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmslash::mwmSlashKCommand entry\n");

  switch(usSlashKParm)
  {
    case 0:
      usLNMODEValue = 0x02;
      break;
    case 1:
      usLNMODEValue = 0x03;
      break;
    case 2:
      usLNMODEValue = 0x01;
      break;
    case 3:
      usLNMODEValue = 0;
      break;
    default:
     usParserStatus= usParserStatus | MWM_ATCMD_ERROR;
  }

  if (!usParserStatus)
  {
    /*************************************************************************/
    /* add the PP command for Slash K to the PP command string.              */
    /*************************************************************************/
    psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x1b | psi->usParserMode);

    /*************************************************************************/
    /* Add the N402 Parameter.                                               */
    /*************************************************************************/
    psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usLNMODEValue;

    /*************************************************************************/
    /* Add the parameter to the end of the PP command string.                */
    /*************************************************************************/
    psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usSlashKParm;

  }
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmslash::mwmSlashKCommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}



/*****************************************************************************/
/* mwmSlashLCommand                                                          */
/*****************************************************************************/
/* Called by...                                                              */
/*   mwmSlashCommand when...                                                 */
/*   Slash L command is encountered in the AT command string.                */
/*                                                                           */
/*   mwmParseInitializeModem when...                                         */
/*   The modem is initialized, either at startup, or when a profile is       */
/*   being loaded into the modem.                                            */
/*                                                                           */
/* The check for buffer full should take place before calling this routine.  */
/*****************************************************************************/
USHORT  mwmSlashLCommand(STATEINFO *psi, USHORT usSlashLParm)
{
  USHORT usParserStatus = 0;
  USHORT usN401Value = 0;
  REGISTERS Registers;
  ULONG  ulRC = 0;

 MW_SYSLOG_1(TRACE_MWMPW32,"mwmslash::mwmSlashLCommand entry\n");
  switch(usSlashLParm)
  {
    case 0:
      usN401Value = 0x40;
      break;
    case 1:
      usN401Value = 0x104;
      break;
    default:
     usParserStatus= usParserStatus | MWM_ATCMD_ERROR;
  }

  if (!usParserStatus)
  {
    /*************************************************************************/
    /* add the PP command for Slash L to the PP command string.              */
    /*************************************************************************/
//    psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x1C | psi->usParserMode);

    /*************************************************************************/
    /* Add the N402 Parameter.                                               */
    /*************************************************************************/
//    psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usN401Value;

    /*************************************************************************/
    /* Add the parameter to the end of the PP command string.                */
    /*************************************************************************/
//    psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usSlashLParm;

    /*************************************************************************/
    /* Update Register                                                       */
    /*************************************************************************/
    mwmParseQueryModemRegisters(&Registers);
    Registers.SlashL = usSlashLParm;
    mwmParseSetModemRegisters(&Registers);

//  DPF("Writing 0x%x to MNPITCB.RN401 (0x%04x)",usN401Value,((psi->dsp.dspaddrMNPITCB)+ offsetof(MNPITCB, RN401)));
    /*************************************************************************/
    /* Set MNPITCB.RN401 to the parameter.                                   */
    /*************************************************************************/
    ulRC = dspMemTransfer(psi->dsp.hDSP, (psi->dsp.dspaddrMNPITCB)+ offsetof(MNPITCB, RN401),
                          &usN401Value, 1,
                          DSP_MEMXFER_DATA_WRITE);
    if (ulRC!=DSP_NOERROR)
    {
      mwmIPCHandleError(szThisFile,__LINE__,&psi->mwmError,
                        MWM_DSP_ERROR, ulRC );
      return (USHORT)ulRC;
    }
  }
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmslash::mwmSlashLCommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}



/*****************************************************************************/
/* mwmSlashNCommand                                                          */
/*****************************************************************************/
/* Called by...                                                              */
/*   mwmSlashCommand when...                                                 */
/*   Slash N command is encountered in the AT command string.                */
/*                                                                           */
/*   mwmParseInitializeModem when...                                              */
/*   The modem is initialized, either at startup, or when a profile is       */
/*   being loaded into the modem.                                            */
/*                                                                           */
/* The check for buffer full should take place before calling this routine.  */
/*****************************************************************************/
USHORT  mwmSlashNCommand(STATEINFO *psi, USHORT usSlashNParm)
{
  USHORT    usParserStatus = 0;
  USHORT    ausNEG_CNTL[3];
  USHORT    usRN400 = 3;
  USHORT    usRT405 = 3;
  REGISTERS Registers;
  ULONG     ulRC;

 MW_SYSLOG_1(TRACE_MWMPW32,"mwmslash::mwmSlashNCommand entry\n");
  /***************************************************************************/
  /* MTS 3009 Allow \N4 and \N5                                              */
  /* MTS 3009 3/29/94 Allow \N6 and \N7                                      */
  /* 3/23/94                                                                 */
  /* For now, allow all of 0-5 if either V.42, MNP, or both are loaded.      */
  /***************************************************************************/
  if ((psi->ulFeaturesToLoad & FEATURE_V42) &&              // DCR 2487
      (psi->ulFeaturesToLoad & FEATURE_MNP) )               // DCR 2487
  {
    if (usSlashNParm > 7)
      usParserStatus = MWM_ATCMD_ERROR;
  }
  else if (psi->ulFeaturesToLoad & FEATURE_V42)
  {
    /*************************************************************************/
    /* Only V.42 means 2,3,6,7 invalid options.                              */
    /*************************************************************************/
    switch (usSlashNParm)
    {
      case 0:
      case 1:
      case 4:
      case 5:
        break;
      default:
        usParserStatus = MWM_ATCMD_ERROR;
    }
  }
  else if (psi->ulFeaturesToLoad & FEATURE_MNP)
  {
    /*************************************************************************/
    /* Only \n0-\n3 are valid in MNP only system.                            */
    /*************************************************************************/
    if (usSlashNParm > 3)
      usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  {
    if (usSlashNParm > 0)
      usParserStatus = MWM_ATCMD_ERROR;
  }

  if (!usParserStatus)
  {
    /*************************************************************************/
    /* Now, we know the parameter is valid for this case.                    */
    /* Let's set the variable values correctly, then write them to the dsp   */
    /*************************************************************************/
    switch (usSlashNParm)
    {
      case 0:
      case 1:
        ausNEG_CNTL[0] = 0;
        ausNEG_CNTL[1] = 0;
        ausNEG_CNTL[2] = 0;
        break;
      case 2:
        ausNEG_CNTL[0] = 0;
        ausNEG_CNTL[1] = 0xffff;
        ausNEG_CNTL[2] = 0xffff;
        break;
      case 3:
        ausNEG_CNTL[0] = 0;
        ausNEG_CNTL[1] = 0xffff;
        ausNEG_CNTL[2] = 0;
        break;
      case 4:
        ausNEG_CNTL[0] = 0xffff;
        ausNEG_CNTL[1] = 0;
        ausNEG_CNTL[2] = 0xffff;
        break;
      case 5:
        ausNEG_CNTL[0] = 0xffff;
        ausNEG_CNTL[1] = 0;
        ausNEG_CNTL[2] = 0;
        break;
      case 6:
        ausNEG_CNTL[0] = 0xffff;
        ausNEG_CNTL[1] = 0xffff;
        ausNEG_CNTL[2] = 0xffff;
        break;
      case 7:
        ausNEG_CNTL[0] = 0xffff;
        ausNEG_CNTL[1] = 0xffff;
        ausNEG_CNTL[2] = 0;
        break;
    }


    /*************************************************************************/
    /* Update Register                                                       */
    /*************************************************************************/
    mwmParseQueryModemRegisters(&Registers);
    Registers.SlashN = usSlashNParm;
    mwmParseSetModemRegisters(&Registers);

//  DPF("Writing 0x%x to MNPITCB.RN400 (0x%04x)",usRN400,((psi->dsp.dspaddrMNPITCB)+ offsetof(MNPITCB, RN400)));
    /*************************************************************************/
    /* Set MNPITCB.RN400 to the parameter.                                   */
    /*************************************************************************/
    ulRC = dspMemTransfer(psi->dsp.hDSP, (psi->dsp.dspaddrMNPITCB)+ offsetof(MNPITCB, RN400),
                          &usRN400, 1,
                          DSP_MEMXFER_DATA_WRITE);
    if (ulRC!=DSP_NOERROR)
    {
      mwmIPCHandleError(szThisFile,__LINE__,&psi->mwmError,
                        MWM_DSP_ERROR, ulRC );
      usParserStatus = MWM_ATCMD_ERROR;
      return usParserStatus;
    }

//  DPF("Writing 0x%x to MNPITCB.RT405 (0x%04x)",usRT405,((psi->dsp.dspaddrMNPITCB)+ offsetof(MNPITCB, RT405)));
    /*************************************************************************/
    /* Set MNPITCB.RN401 to the parameter.                                   */
    /*************************************************************************/
    ulRC = dspMemTransfer(psi->dsp.hDSP, (psi->dsp.dspaddrMNPITCB)+ offsetof(MNPITCB, RT405),
                          &usRT405, 1,
                          DSP_MEMXFER_DATA_WRITE);
    if (ulRC!=DSP_NOERROR)
    {
      mwmIPCHandleError(szThisFile,__LINE__,&psi->mwmError,
                        MWM_DSP_ERROR, ulRC );
      usParserStatus = MWM_ATCMD_ERROR;
      return usParserStatus;
    }


//  DPF("Writing 0x%x,0x%x,0x%x to MCTL.NEG_CNTL (0x%04x)",ausNEG_CNTL[0],ausNEG_CNTL[1],ausNEG_CNTL[2],(psi->dsp.dspaddrNEGCNTL));
    /*************************************************************************/
    /* Set MCTL.NEG_CNTL to the parameter.                                   */
    /*************************************************************************/
    ulRC = dspMemTransfer(psi->dsp.hDSP, psi->dsp.dspaddrNEGCNTL,
                          ausNEG_CNTL, 3,
                          DSP_MEMXFER_DATA_WRITE);
    if (ulRC!=DSP_NOERROR)
    {
      mwmIPCHandleError(szThisFile,__LINE__,&psi->mwmError,
                        MWM_DSP_ERROR, ulRC );
      usParserStatus = MWM_ATCMD_ERROR;
      return usParserStatus;
    }


    /*************************************************************************/
    /* add the PP command for Slash K to the PP command string.              */
    /*************************************************************************/
//    psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x1D | psi->usParserMode);

    /*************************************************************************/
    /* Add the parameter to the end of the PP command string.                */
    /*************************************************************************/
//    psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usSlashNParm;
  }
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmslash::mwmSlashNCommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}

/*****************************************************************************/
/* mwmSlashQCommand                                                          */
/*****************************************************************************/
/* Called by...                                                              */
/*   mwmSlashCommand when...                                                 */
/*   Slash Q command is encountered in the AT command string.                */
/*                                                                           */
/* The check for buffer full should take place before calling this routine.  */
/*****************************************************************************/
USHORT  mwmSlashQCommand(STATEINFO *psi, USHORT usParm)
{
  USHORT usParserStatus = 0;

 MW_SYSLOG_1(TRACE_MWMPW32,"mwmslash::mwmSlashQCommand entry\n");
  switch (usParm)
  {
    case 0:
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x2B | psi->usParserMode);
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usParm;
      break;
    case 3:
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x2B | psi->usParserMode);
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usParm;
      break;
    default:
      usParserStatus = MWM_ATCMD_ERROR;
  }
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmslash::mwmSlashQCommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}




// MTS6384 Split SlashT into 2 procedures to allow S30= to share the code
/*****************************************************************************/
/* mwmSlashTCommand                                                          */
/*****************************************************************************/
/* Called by...                                                              */
/*   mwmSlashCommand when...                                                 */
/*   Slash T command is encountered in the AT command string.                */
/*                                                                           */
/* The check for buffer full should take place before calling this routine.  */
/*****************************************************************************/
USHORT  mwmSlashTCommand(STATEINFO *psi, USHORT usSlashTParm)
{
  USHORT usParserStatus = 0;

 MW_SYSLOG_1(TRACE_MWMPW32,"mwmslash::mwmSlashTCommand entry\n");
  if (usSlashTParm > 90)
    usParserStatus = MWM_ATCMD_ERROR;
  else
    mwmParseSetDisconnectTime( psi, (USHORT)(usSlashTParm * 60) );
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmslash::mwmSlashTCommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}



/*****************************************************************************/
/* mwmSlashVCommand                                                          */
/*****************************************************************************/
/* Called by...                                                              */
/*   mwmSlashCommand when...                                                 */
/*   Slash V command is encountered in the AT command string.                */
/*                                                                           */
/* The check for buffer full should take place before calling this routine.  */
/*****************************************************************************/
USHORT  mwmSlashVCommand(STATEINFO *psi, USHORT usSlashVParm)
{
  USHORT usParserStatus = 0;

 MW_SYSLOG_1(TRACE_MWMPW32,"mwmslash::mwmSlashVCommand entry\n");
   if (usSlashVParm == 0)
   {
     mwmParseSetSRegister(psi->ausPPcmdBuffer,
                          &psi->usNextPPIndex,
                          14,0xffff,0x10);
   }
   else if (usSlashVParm == 1)
   {
     mwmParseSetSRegister(psi->ausPPcmdBuffer,
                          &psi->usNextPPIndex,
                          14,0xffef,0);
   }
   else
     usParserStatus = MWM_ATCMD_ERROR;

 MW_SYSLOG_2(TRACE_MWMPW32,"mwmslash::mwmSlashVCommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}


/*****************************************************************************/
/* mwmSlashZCommand                                                          */
/*****************************************************************************/
/* Called by...                                                              */
/*   mwmSlashCommand when...                                                 */
/*   Slash Z command is encountered in the AT command string.                */
/*                                                                           */
/* The check for buffer full should take place before calling this routine.  */
/*****************************************************************************/
USHORT  mwmSlashZCommand(STATEINFO *psi, USHORT usSlashZParm)
{
  USHORT usParserStatus = 0;

 MW_SYSLOG_1(TRACE_MWMPW32,"mwmslash::mwmSlashZCommand entry\n");
   if (usSlashZParm == 0)
   {
     /************************************************************************/
     /* add the PP command for Slash Z to the PP command string.             */
     /************************************************************************/
     psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x22 | psi->usParserMode);
     psi->ausPPcmdBuffer[psi->usNextPPIndex++] = 0;
   }
   else if (usSlashZParm == 1)
   {
     /************************************************************************/
     /* add the PP command for Slash Z to the PP command string.             */
     /************************************************************************/
     psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x22 | psi->usParserMode);
     psi->ausPPcmdBuffer[psi->usNextPPIndex++] = 1;
   }
   else
     usParserStatus = MWM_ATCMD_ERROR;
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmslash::mwmSlashZCommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}





