//  MusE
//  Linux Music Editor
//    $Id: noteinfo.h,v 1.1.1.1 2003/10/29 10:06:31 wschweer Exp $
//  (C) Copyright 1999 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __NOTE_INFO_H__
#define __NOTE_INFO_H__

#include <qtoolbar.h>

class PosEdit;
class QSpinBox;
class PitchEdit;
class QMainWindow;
class Pos;

//---------------------------------------------------------
//   NoteInfo
//---------------------------------------------------------

class NoteInfo : public QToolBar {
      PosEdit* selTime;
      QSpinBox* selLen;
      PitchEdit* selPitch;
      QSpinBox* selVelOn;
      QSpinBox* selVelOff;
//      QSpinBox* selChannel;

      Q_OBJECT

   public:
      enum ValType {VAL_TIME, VAL_LEN, VAL_VELON, VAL_VELOFF, VAL_PITCH };
      NoteInfo(QMainWindow* parent);
      void setValues(int, int, int, int, int);

   private:
   private slots:
      void lenChanged(int);
      void velOnChanged(int);
      void velOffChanged(int);
//      void channelChanged(int);
      void pitchChanged(int);
      void timeChanged(const Pos&);

   public slots:
      void setValue(ValType, int);

   signals:
      void valueChanged(NoteInfo::ValType, int);
      };
#endif

