//=========================================================
//  MusE
//  Linux Music Editor
//    $Id: piano.h,v 1.1.1.1 2003/10/29 10:06:10 wschweer Exp $
//  (C) Copyright 1999 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __PIANO_H__
#define __PIANO_H__

#include "view.h"

class QPainter;

#define KH  13

//---------------------------------------------------------
//   Piano
//---------------------------------------------------------

class Piano : public View
      {
      int curPitch;
      QPixmap* octave;
      QPixmap* mk1;
      QPixmap* mk2;
      QPixmap* mk3;
      QPixmap* mk4;
      int keyDown;
      bool shift;
      int button;

      Q_OBJECT
      int y2pitch(int) const;
      int pitch2y(int) const;
      void viewMouseMoveEvent(QMouseEvent* event);
      virtual void leaveEvent(QEvent*e);

      virtual void viewMousePressEvent(QMouseEvent* event);
      virtual void viewMouseReleaseEvent(QMouseEvent*);

   protected:
      virtual void draw(QPainter&, const QRect&);

   signals:
      void pitchChanged(int);
      void keyPressed(int, bool);
      void keyReleased(int, bool);

   public slots:
      void setPitch(int);

   public:
      Piano(QWidget*, int);
      };

#endif

