//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: audioprefetch.h,v 1.1.1.1 2003/10/29 10:05:06 wschweer Exp $
//
//  (C) Copyright 2001 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __AUDIOPREFETCH_H__
#define __AUDIOPREFETCH_H__

#include "thread.h"


enum { PREFETCH_TICK, PREFETCH_SEEK
      };

struct PrefetchMsg : public ThreadMsg {
      int pos;
      };

//---------------------------------------------------------
//   AudioPrefetch
//---------------------------------------------------------

class AudioPrefetch : public Thread {
      int readSamplePos;

      virtual void processMsg1(const void*);
      void prefetch();
      void seek(int pos);
      int seekpos;

   public:
      AudioPrefetch(int prio, const char* name);
      ~AudioPrefetch();
      virtual void start();

      void msgTick();
      void msgSeek(int samplePos);
      };

extern AudioPrefetch* audioPrefetch;

#endif
