//=========================================================
//  MusE
//  Linux Music Editor
//    $Id: dentry.h,v 1.2 2001/11/20 15:19:34 muse Exp $
//  (C) Copyright 1999 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __DENTRY_H__
#define __DENTRY_H__

#include <qlineedit.h>

class QTimer;

//---------------------------------------------------------
//   Dentry
//---------------------------------------------------------

class Dentry : public QLineEdit {
      int button;
      int starty;
      bool drawFrame;
      QTimer* timer;
      double evx;
      int timecount;

      Q_OBJECT
      virtual void mousePressEvent(QMouseEvent*);
      virtual void mouseMoveEvent(QMouseEvent*);
      virtual void mouseDoubleClickEvent(QMouseEvent*);
      virtual void mouseReleaseEvent(QMouseEvent*);

   protected:
      double val;

      virtual void incValue(double x) = 0;
      virtual void decValue(double x) = 0;
      virtual bool setString(double) = 0;
      virtual bool setSValue(const QString&) = 0;

   private slots:
      void repeat();

   protected slots:
      void endEdit();

   signals:
      void valueChanged(double);

   public slots:
      virtual void setValue(double);

   public:
      Dentry(QWidget*);
      double value() const { return val; }
      void setFrame(bool);
      };
#endif
