//=========================================================
//  MusE
//  Linux Music Editor
//    $Id: waveview.h,v 1.2 2001/11/20 15:19:34 muse Exp $
//  (C) Copyright 2000 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef WAVE_VIEW_H
#define WAVE_VIEW_H

#include "view.h"
#include <qwidget.h>

class PartList;
class QPainter;
class QRect;
class WavePart;
class MidiEditor;

//---------------------------------------------------------
//   WaveView
//---------------------------------------------------------

class WaveView : public View {
      MidiEditor* editor;
      int pos[3];
      int yScale;
      int button;
      int startSample;
      int endSample;

      WavePart* curPart;
      int curPartId;

      Q_OBJECT
      virtual void pdraw(QPainter&, const QRect&);
      virtual void draw(QPainter&, const QRect&);
      virtual void viewMousePressEvent(QMouseEvent*);
      virtual void viewMouseMoveEvent(QMouseEvent*);
      virtual void viewMouseReleaseEvent(QMouseEvent*);

   private slots:
      void setPos(int idx, int val, bool adjustScrollbar);

   public slots:
      void setYScale(int);

   signals:
      void followEvent(int);
      void timeChanged(int);

   public:
      WaveView(MidiEditor*, QWidget* parent, int xscale, int yscale);
      QString getCaption() const;
      void songChanged(int type);
      void range(int*, int*);
      };

#endif

