#ifndef MSTYLE_H
#define MSTYLE_H

#include <qwindowsstyle.h>
#include <qpalette.h>

//---------------------------------------------------------
//   MuseStyle
//---------------------------------------------------------

class MuseStyle : public QWindowsStyle
      {
      QPalette oldPalette;

      void drawMetalFrame(  QPainter *p, int x, int y, int w, int h ) const;
      void drawMetalGradient( QPainter *p, int x, int y, int w, int h,
			  bool sunken, bool horz, bool flat=FALSE ) const;
      void drawMetalButton( QPainter *p, int x, int y, int w, int h,
			  bool sunken, bool horz, bool flat=FALSE ) const;

   public:
      MuseStyle();
      void polish( QApplication*);
      void unPolish( QApplication*);
      void polish( QWidget* );
      void unPolish( QWidget* );

      void drawPrimitive(PrimitiveElement pe,
         QPainter *p, const QRect &r, const QColorGroup &cg,
         SFlags flags = Style_Default,
         const QStyleOption& = QStyleOption::Default) const;

      void drawControl(ControlElement element,
         QPainter *p,
         const QWidget *widget,
         const QRect &r,
         const QColorGroup &cg,
         SFlags how = Style_Default,
         const QStyleOption& = QStyleOption::Default ) const;

      void drawComplexControl( ComplexControl cc,
         QPainter *p,
         const QWidget *widget,
         const QRect &r,
         const QColorGroup &cg,
         SFlags how = Style_Default,
         SCFlags sub = SC_All,
         SCFlags subActive = SC_None,
         const QStyleOption& = QStyleOption::Default ) const;
         int pixelMetric( PixelMetric, const QWidget * ) const;
      };

#endif

