//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: sfont.h,v 1.2 2001/11/20 15:19:34 muse Exp $
//
//  This file is derived from IIWU Synth and modified
//    for MusE.
//  Parts of IIWU are derived from Smurf Sound Font Editor.
//  Parts of Smurf Sound Font Editor are derived from
//    awesfx utilities
//  Smurf:  Copyright (C) 1999-2000 Josh Green
//  IIWU:   Copyright (C) 2001 Peter Hanappe
//  MusE:   Copyright (C) 2001 Werner Schweer
//  awesfx: Copyright (C) 1996-1999 Takashi Iwai
//=========================================================

#ifndef __SFONT_H__
#define __SFONT_H__

#include <stdio.h>
#include <setjmp.h>
#include "mess.h"

class SFMod;
class SFont;
class Zone;

#define Gen_MaxValid 	Gen_Dummy - 1	/* maximum valid generator */
#define Gen_Count	Gen_Dummy	/* count of generators */
#define GenArrSize sizeof(SFGenAmount)*Gen_Count	/* gen array size */

/* sfont file chunk sizes */
#define SFPHDRSIZE      38
#define SFBAGSIZE       4
#define SFMODSIZE       10
#define SFGENSIZE       4
#define SFIHDRSIZE	22
#define SFSHDRSIZE	46

#define SF_SAMPLETYPE_MONO	1
#define SF_SAMPLETYPE_RIGHT	2
#define SF_SAMPLETYPE_LEFT	4
#define SF_SAMPLETYPE_LINKED	8
#define SF_SAMPLETYPE_ROM	0x8000
#define SF_SAMPMODES_LOOP	1
#define SF_SAMPMODES_UNROLL	2
#define SF_MIN_SAMPLERATE	400
#define SF_MAX_SAMPLERATE	50000
#define SF_MIN_SAMPLE_LENGTH	32

//---------------------------------------------------------
//   SFVersion
//---------------------------------------------------------

struct SFVersion {
      unsigned major;
      unsigned minor;
      };

//---------------------------------------------------------
//   SFInfo
//---------------------------------------------------------

struct SFInfo {
      SFInfo* next;
      char* data;
      };

//---------------------------------------------------------
//   iiwu_gen_type
//---------------------------------------------------------

enum iiwu_gen_type {
      GEN_STARTADDROFS,
      GEN_ENDADDROFS,
      GEN_STARTLOOPADDROFS,
      GEN_ENDLOOPADDROFS,
      GEN_STARTADDRCOARSEOFS,
      GEN_MODLFOTOPITCH,
      GEN_VIBLFOTOPITCH,
      GEN_MODENVTOPITCH,
      GEN_FILTERFC,
      GEN_FILTERQ,
      GEN_MODLFOTOFILTERFC,
      GEN_MODENVTOFILTERFC,
      GEN_ENDADDRCOARSEOFS,
      GEN_MODLFOTOVOL,
      GEN_UNUSED1,
      GEN_CHORUSSEND,
      GEN_REVERBSEND,
      GEN_PAN,
      GEN_UNUSED2,
      GEN_UNUSED3,
      GEN_UNUSED4,          // 20
      GEN_MODLFODELAY,
      GEN_MODLFOFREQ,
      GEN_VIBLFODELAY,
      GEN_VIBLFOFREQ,
      GEN_MODENVDELAY,
      GEN_MODENVATTACK,
      GEN_MODENVHOLD,
      GEN_MODENVDECAY,
      GEN_MODENVSUSTAIN,
      GEN_MODENVRELEASE,
      GEN_KEYTOMODENVHOLD,
      GEN_KEYTOMODENVDECAY,
      GEN_VOLENVDELAY,
      GEN_VOLENVATTACK,
      GEN_VOLENVHOLD,
      GEN_VOLENVDECAY,
      GEN_VOLENVSUSTAIN,
      GEN_VOLENVRELEASE,
      GEN_KEYTOVOLENVHOLD,
      GEN_KEYTOVOLENVDECAY, // 40
      GEN_INSTRUMENT,
      GEN_RESERVED1,
      GEN_KEYRANGE,
      GEN_VELRANGE,
      GEN_STARTLOOPADDRCOARSEOFS,
      GEN_KEYNUM,
      GEN_VELOCITY,
      GEN_ATTENUATION,
      GEN_RESERVED2,
      GEN_ENDLOOPADDRCOARSEOFS,
      GEN_COARSETUNE,
      GEN_FINETUNE,
      GEN_SAMPLEID,
      GEN_SAMPLEMODE,
      GEN_RESERVED3,
      GEN_SCALETUNE,
      GEN_EXCLUSIVECLASS,
      GEN_OVERRIDEROOTKEY,
      GEN_PITCH,     /* the initial pitch is not a "standard"
    		  * generator. It is not mentioned in the list of
    		  * generator in the SF2 specifications. It is used,
    		  * however, as the destination for the default pitch
    		  * wheel modulator. */
      GEN_LAST
      };

/* generator types */
enum Gen_Type {
      Gen_StartAddrOfs,
      Gen_EndAddrOfs,
      Gen_StartLoopAddrOfs,
      Gen_EndLoopAddrOfs,
      Gen_StartAddrCoarseOfs,
      Gen_ModLFO2Pitch,
      Gen_VibLFO2Pitch,
      Gen_ModEnv2Pitch,
      Gen_FilterFc,
      Gen_FilterQ,
      Gen_ModLFO2FilterFc,
      Gen_ModEnv2FilterFc,
      Gen_EndAddrCoarseOfs,
      Gen_ModLFO2Vol,
      Gen_Unused1,
      Gen_ChorusSend,
      Gen_ReverbSend,
      Gen_Pan,
      Gen_Unused2,
      Gen_Unused3,
/*20*/Gen_Unused4,
      Gen_ModLFODelay,
      Gen_ModLFOFreq,
      Gen_VibLFODelay,
      Gen_VibLFOFreq,
      Gen_ModEnvDelay,
      Gen_ModEnvAttack,
      Gen_ModEnvHold,
      Gen_ModEnvDecay,
      Gen_ModEnvSustain,
      Gen_ModEnvRelease,
      Gen_Key2ModEnvHold,
      Gen_Key2ModEnvDecay,
      Gen_VolEnvDelay,
      Gen_VolEnvAttack,
      Gen_VolEnvHold,
      Gen_VolEnvDecay,
      Gen_VolEnvSustain,
      Gen_VolEnvRelease,
      Gen_Key2VolEnvHold,
/*40*/Gen_Key2VolEnvDecay,
      Gen_Instrument,
      Gen_Reserved1,
      Gen_KeyRange,
      Gen_VelRange,
      Gen_StartLoopAddrCoarseOfs,
      Gen_Keynum,
      Gen_Velocity,
      Gen_Attenuation,
      Gen_Reserved2,
      Gen_EndLoopAddrCoarseOfs,
      Gen_CoarseTune,
      Gen_FineTune,
      Gen_SampleId,
      Gen_SampleModes,
      Gen_Reserved3,
      Gen_ScaleTune,
      Gen_ExclusiveClass,
      Gen_OverrideRootKey,
/*59*/Gen_Dummy
      };

//---------------------------------------------------------
//   Preset
//---------------------------------------------------------

class Preset : public MidiPatch {
      SFont* _sfont;          // the soundfont this preset belongs to

   public:
      Preset* next;

      unsigned libr;		// Not used (preserved)
      unsigned genre;		// Not used (preserved)
      unsigned morph;		// Not used (preserved)
      Zone* zone;		      // list of preset zones
      int zoneIndex;

   public:
      Preset();
      ~Preset();
      void setSFont(SFont* sf) {  _sfont = sf;  }
      SFont* sfont()           { return _sfont; }
      void dump() const;
      };

//---------------------------------------------------------
//   Sample
//---------------------------------------------------------

class Sample {
      const short* _data;
      char _name[21];		// Name of sample

   public:
      Sample* next;           // the next sample in the chained list
      unsigned int start;
      unsigned int end;
      unsigned int loopstart;
      unsigned int loopend;
      unsigned int samplerate;
      int origpitch;
      int pitchadj;
      int cents;
      unsigned sampletype;    // 1 mono,2 right,4 left,linked 8,0x8000=ROM

   public:
      Sample();
      ~Sample();
      int in_rom() const { return sampletype & SF_SAMPLETYPE_ROM; }
      const short* data() const { return _data; }
      void setData(const short* val) { _data = val; }
      char* name() { return _name; }
      };

//---------------------------------------------------------
//   Inst
//    Instrument structure
//---------------------------------------------------------

class Inst {
   public:
      Inst* next;

      char name[21];        // Name of instrument
      Zone* zone;           // list of instrument zones

      Inst();
      ~Inst();

      void dump() const;
      };

//---------------------------------------------------------
//   Gen
//---------------------------------------------------------

enum GenFlags { GEN_UNUSED, GEN_SET, GEN_CHANGED };

struct Gen {
      GenFlags flags;
      double val;
      double mod;
      };

//---------------------------------------------------------
//   Zone
//    Sample/instrument zone structure
//---------------------------------------------------------

class Zone {
   public:
      int instsampno;         // instrument/sample pointer for zone
      Inst* inst;
      Sample* samp;

      int sfgen;
      SFMod *mod;		      // list of modulators

      int keylo;
      int keyhi;
      int vello;
      int velhi;
      Gen gen[GEN_LAST];

   public:
      Zone();
      ~Zone();
      Zone* next;
      int inside_range(int,int);
      Sample* getSample() const { return samp; }

      void dump() const;
      };

//---------------------------------------------------------
//   SFChunk
//---------------------------------------------------------

struct SFChunk {              // RIFF file chunk structure
      unsigned id;	      // chunk id
      unsigned size;	      // size of the following chunk
      };

//---------------------------------------------------------
//   SFMod
//    Modulator structure
//---------------------------------------------------------

class SFMod {
   public:
      SFMod* next;

      unsigned src;	            // source modulator
      unsigned dest;	            // destination generator
      int amount;		            // signed, degree of modulation
      unsigned amtsrc;	            // second source controls amnt of first
      unsigned trans;	            // transform applied to source

   public:
      void dump() const;
      };

//---------------------------------------------------------
//   SFont
//---------------------------------------------------------

class SFont {
      SFVersion version;	// sound font version
      SFVersion romver;		// ROM version
      FILE* fd;			// loaded sfont file descriptor
      int fsize;              // sfont file size
      SFInfo* info;		// linked list of info strings (1st byte is ID)
      Inst* inst;		      // linked list of instrument info

      unsigned samplepos;	// position within fd of the sample chunk
      unsigned samplesize;	// length within fd of the sample chunk
      Sample* sample;		// linked list of sample info
      short* sampledata;      // the sample data, loaded in ram

      const char* file;       // the filename of this soundfont
      int sdtachunk_size;
      jmp_buf env;

      void process_info(int size);
      void load_phdr(int size);
      void process_pdta(int size);
      void load_pbag(int size);
      void load_pmod(int size);
      void load_shdr(int size);
      void fixup_pgen();
      void fixup_igen();
      void fixup_sample();
      void load_pgen(int size);
      void load_ihdr(int size);
      void load_ibag(int size);
      void load_imod(int size);
      void load_igen(int size);
      void process_sdta(int size);
      void pdtahelper(unsigned expid, unsigned reclen, SFChunk* chunk, int* size);

      int readw();
      unsigned int readWord();
      int readd();
      int readb();
      unsigned int readByte();
      void fskip(int);
      void safe_fread(void *buf, int count);
      void readid(unsigned* var);
      void readstr(char* var);
      void read_listchunk(SFChunk* chunk);

   public:
      SFont();
      ~SFont();

      SFont* next;
      Preset* preset;		// linked list of preset info

      int load(const char* file);
      void load_sampledata();
      void add_preset(Preset* preset);
      Preset* get_preset(char hbank, char lbank, char num);
      Sample* get_sample(const char *s) const;
      void append_sfont(SFont* sfont2);
      void load_body();
      bool sfload_file(FILE* fd);
      const char* filePath() const { return file; }

      void dump() const;
      };

extern void gen_init_array(Gen* gen);

#endif

