//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: iiwugui.cpp,v 1.2 2002/02/01 17:55:39 bob Exp $
//
//    This is a simple GUI implemented with QT for
//    iiwu software synthesizer.
//
//  (C) Copyright 2001 Werner Schweer (ws@seh.de)
//=========================================================

#include <unistd.h>
#include <stdlib.h>
#include "iiwugui.h"
#include <qapplication.h>
#include <qpixmap.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qtoolbutton.h>
#include <qpushbutton.h>
#include <qfiledialog.h>
#include <qmessagebox.h>
#include <qsocketnotifier.h>

/*
      The interface to the software synthesizer is implemented
      as a pipe connected from stdout of this gui process to
      MusE. MusE redirects the received input to the iiwu software
      synthesizer midi device.

      In short communication to the synt takes place as
      midi commands written to stdout.

      All special handling of the synth is done via
      sysex midi commands.
*/

//---------------------------------------------------------
//   IIWUGui
//---------------------------------------------------------

IIWUGui::IIWUGui()
   : IIWUGuiBase(0, "iiwugui", WType_TopLevel | WDestructiveClose)
      {
      QSocketNotifier* s = new QSocketNotifier(0, QSocketNotifier::Read);
      connect(s, SIGNAL(activated(int)), SLOT(readStdin(int)));

      connect(fdialogButton, SIGNAL(clicked()), SLOT(soundFontFileDialog()));
      connect(loadButton, SIGNAL(clicked()), SLOT(loadFont()));
      }

//---------------------------------------------------------
//   readStdin
//---------------------------------------------------------

void IIWUGui::readStdin(int fd)
      {
      char buffer[128];
      int n = ::read(fd, buffer, 128);
      printf("IIWU GUI: read %d Bytes from STDIN\n", n);
      }

//---------------------------------------------------------
//   loadFont
//    sysex f0 7c 00 01 name f7
//---------------------------------------------------------

void IIWUGui::loadFont()
      {
      if (!pathEntry->text().isEmpty()) {
            QFileInfo fi(pathEntry->text());
            if (!fi.exists()) {
                  QString s = "SoundFont " + pathEntry->text() + " does not exists";
                  QMessageBox::critical(this, "IIWU: open Soundfile", s);
                  return;
                  }

            fputc(0xf0, stdout);
            fputc(0x7c, stdout);    // MusE soft synthesizer
            fputc(0x00, stdout);    // iiwu
            fputc(0x01, stdout);    // load sound font
            const char* path = pathEntry->text().latin1();
            fputs(path, stdout);
            fputc(0xf7, stdout);
            fflush(stdout);
            }
      }

//---------------------------------------------------------
//   soundFontFileDialog
//---------------------------------------------------------

void IIWUGui::soundFontFileDialog()
      {
      QString s = QFileDialog::getOpenFileName(QString::null, "*.[Ss][Ff]2", this);
      if (!s.isEmpty()) {
            pathEntry->setText(s);
            }
      }

//---------------------------------------------------------
//   closeEvent
//---------------------------------------------------------

void IIWUGui::closeEvent(QCloseEvent* ce)
      {
      ce->accept();
      exit(0);
      }

//---------------------------------------------------------
//   main
//---------------------------------------------------------

int main(int argc, char* argv[])
      {
      QApplication app(argc, argv, true);
      QWidget* w = new IIWUGui;
      if (argc > 1)
            w->setCaption(argv[1]);
      w->show();
      app.connect(&app, SIGNAL(lastWindowClosed()), &app, SLOT(quit()));
      qApp->exec();
      }

