//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: ssource.cpp,v 1.1 2002/01/30 14:10:07 muse Exp $
//
//  (C) Copyright 2001 Werner Schweer (ws@seh.de)
//=========================================================

#include "ssource.h"

//---------------------------------------------------------
//   SoundSource
//---------------------------------------------------------

SoundSource::SoundSource()
      {
      _mute        = false;
      _soloMute    = false;
      _curActivity = 0;
      _channels    = 2;

      for (int i = 0; i < AUDIO_CHANNELS; ++i) {
            _activity[i] = 0;
            _peak[i]     = 0;
            }
      }

SoundSource::SoundSource(const SoundSource& s)
   : QObject()
      {
      _mute        = s._mute;
      _soloMute    = s._soloMute;
      _curActivity = s._curActivity;
      _channels    = s._channels;
      for (int i = 0; i < AUDIO_CHANNELS; ++i) {
            _activity[i] = 0;
            _peak[i]     = 0;
            }
      }

//---------------------------------------------------------
//   setChannels
//---------------------------------------------------------

void SoundSource::setChannels(int val)
      {
      _channels = val;
      }

//---------------------------------------------------------
//   resetPeaks
//---------------------------------------------------------

void SoundSource::resetPeaks()
      {
      for (int i = 0; i < channels(); ++i)
            _peak[i] = 0;
      }

//---------------------------------------------------------
//   resetMeter
//---------------------------------------------------------

void SoundSource::resetMeter()
      {
      for (int i = 0; i < channels(); ++i)
            _activity[i] = 0;
      }


bool SoundSource::mute() const                { return _mute; }
bool SoundSource::soloMute() const            { return _soloMute; }

void SoundSource::setMute(bool val)           { _mute = val; }
void SoundSource::setSolo(bool val)           { _soloMute = val; }

int SoundSource::channels() const             { return _channels; }

void SoundSource::setActivity(int v, int c=0) { _activity[c] = v; }
void SoundSource::addActivity(int v, int c=0) { _activity[c] += v; }

      // for midi (obsolete?):
int SoundSource::curActivity() const          { return _curActivity; }
void SoundSource::setCurActivity(int v)       { _curActivity = v; }

int SoundSource::peak(int channel)            { return _peak[channel]; }
int SoundSource::activity(int channel=0)      { return _activity[channel]; }

