//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: seq.h,v 1.3 2002/02/13 11:42:56 muse Exp $
//
//  (C) Copyright 1999/2000 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __SEQ_H__
#define __SEQ_H__

#include <qobject.h>
#include <pthread.h>
#include <qstring.h>
#include <unistd.h>
#include "mtc.h"
#include "value.h"
#include "audiomix.h"
#include "tempo.h"

class Xml;
class AudioPort;
class EventList;
class SEventList;
class MidiEvent;

class SndFile;

//---------------------------------------------------------
//   Sequencer
//---------------------------------------------------------

class Sequencer : public QObject {
      // recording values
      int recStartTick;
      int nextClick;

      Q_OBJECT;
      void loadConfigMetronom(Xml& xml);
      void readConfigAudioPort(Xml& xml);
      void readConfigAudioGroup(Xml& xml);
      void readConfigAudioMaster(Xml& xml);
      void readConfigMidiPort(Xml& xml);
      void readMixdown(Xml& xml);
      bool notify();

   public:
      Sequencer();
      ~Sequencer();

      void startThread();
      void stopThread();

      void writeConfiguration(int, Xml&);
      void readConfiguration(Xml&);
      };
#endif

