//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: minstrument.h,v 1.3 2002/02/07 08:14:48 muse Exp $
//
//  (C) Copyright 2000 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __MINSTRUMENT_H__
#define __MINSTRUMENT_H__

#include "globaldefs.h"
#include <list>
#include <qstring.h>

class MidiPort;
class QPopupMenu;
class MidiEvent;
class Xml;
class EventList;

//---------------------------------------------------------
//   MidiInstrument
//---------------------------------------------------------

class MidiInstrument {

   protected:
      EventList* _midiInit;
      EventList* _midiState;
      QString _name;

   public:
      MidiInstrument();
      virtual ~MidiInstrument();
      MidiInstrument(const QString& txt);
      const QString& iname() const      { return _name; }
      void setIName(const QString& txt) { _name = txt; }

      EventList* midiInit() const { return _midiInit; }
      EventList* midiState() const { return _midiState; }

      void readMidiState(Xml&);
      void readMidiInit(Xml&);

      virtual bool guiVisible() const  { return false; }
      virtual void showGui(bool)       {}
      virtual bool hasGui() const      { return false; }
      virtual void writeToGui(const MidiEvent*) {}

      virtual void reset(int, MType)   {}
      virtual const char* getPatchName(int,int,int,int,MType);
      virtual void populatePatchPopup(QPopupMenu*, int, MType) {}
      };

//---------------------------------------------------------
//   MidiInstrumentList
//---------------------------------------------------------

class MidiInstrumentList : public std::list<MidiInstrument*> {

   public:
      MidiInstrumentList() {}
      };

typedef std::list<MidiInstrument*>::iterator iMidiInstrument;

//---------------------------------------------------------
//   MidiGMInstrument
//---------------------------------------------------------

class MidiGMInstrument : public MidiInstrument {

   public:
      MidiGMInstrument() {};
      MidiGMInstrument(const QString& txt) : MidiInstrument(txt) {}
      virtual void reset(int port, MType type);
      virtual const char* getPatchName(int,int,int,int,MType);
      virtual void populatePatchPopup(QPopupMenu*, int, MType);
      };

//---------------------------------------------------------
//   MidiGSInstrument
//---------------------------------------------------------

class MidiGSInstrument : public MidiInstrument {

   public:
      MidiGSInstrument() {};
      MidiGSInstrument(const QString& txt) : MidiInstrument(txt) {}
      virtual void reset(int port, MType type);
      virtual const char* getPatchName(int,int,int,int,MType);
      virtual void populatePatchPopup(QPopupMenu*, int, MType);
      };

//---------------------------------------------------------
//   MidiXGInstrument
//---------------------------------------------------------

class MidiXGInstrument : public MidiInstrument {

   public:
      MidiXGInstrument() {};
      MidiXGInstrument(const QString& txt) : MidiInstrument(txt) {}
      virtual void reset(int port, MType type);
      virtual const char* getPatchName(int,int,int,int,MType);
      virtual void populatePatchPopup(QPopupMenu*, int, MType);
      };

struct ProgItem {
      const char* name;
      int id;
      };

//---------------------------------------------------------
//   MidiP50mInstrument
//---------------------------------------------------------

class MidiP50mInstrument : public MidiInstrument {
      static ProgItem progList[29];

   public:
      MidiP50mInstrument() {};
      MidiP50mInstrument(const QString& txt) : MidiInstrument(txt) {}
      virtual void reset(int port, MType type);
      virtual const char* getPatchName(int,int,int,int,MType);
      virtual void populatePatchPopup(QPopupMenu*, int, MType);
      };

//---------------------------------------------------------
//   MidiNS5RInstrument
//---------------------------------------------------------

class MidiNS5RInstrument : public MidiInstrument {
      MType mode;
   public:
      MidiNS5RInstrument() {
            mode = MT_XG;
            };
      MidiNS5RInstrument(const QString& txt) : MidiInstrument(txt) {
            mode = MT_XG;
            }
      virtual void reset(int port, MType type);
      virtual const char* getPatchName(int,int,int,int,MType);
      virtual void populatePatchPopup(QPopupMenu*, int, MType);
      };

extern MidiInstrumentList midiInstruments;
extern MidiInstrument* genericMidiInstrument;
extern void initMidiInstruments();
extern MidiInstrument* registerMidiInstrument(const QString&);
extern void removeMidiInstrument(const QString& name);


#endif
