//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: drummap.cpp,v 1.1 2002/01/30 14:10:08 muse Exp $
//
//  (C) Copyright 1999/2000 Werner Schweer (ws@seh.de)
//=========================================================

#include "drummap.h"
#include "xml.h"

char drumOutmap[DRUM_MAPSIZE];
char drumInmap[128];

DrumMap drumMap[DRUM_MAPSIZE];

//---------------------------------------------------------
//    GM default drum map
//---------------------------------------------------------

const DrumMap idrumMap[DRUM_MAPSIZE] = {
      { "Acoustic Bass Drum", 16, 32, 9, 0, 70, 90, 110, 127, 35, 35, false, false },
      { "Bass Drum 1",        16, 32, 9, 0, 70, 90, 110, 127, 36, 36, false, false },
      { "Side Stick",         16, 32, 9, 0, 70, 90, 110, 127, 37, 37, false, false },
      { "Acoustic Snare",     16, 32, 9, 0, 70, 90, 110, 127, 38, 38, false, false },
      { "Hand Clap",          16, 32, 9, 0, 70, 90, 110, 127, 39, 39, false, false },
      { "Electric Snare",     16, 32, 9, 0, 70, 90, 110, 127, 40, 40, false, false },
      { "Low Floor Tom",      16, 32, 9, 0, 70, 90, 110, 127, 41, 41, false, false },
      { "Closed Hi-Hat",      16, 32, 9, 0, 70, 90, 110, 127, 42, 42, false, false },
      { "High Floor Tom",     16, 32, 9, 0, 70, 90, 110, 127, 43, 43, false, false },
      { "Pedal Hi-Hat",       16, 32, 9, 0, 70, 90, 110, 127, 44, 44, false, false },
      { "Low Tom",            16, 32, 9, 0, 70, 90, 110, 127, 45, 45, false, false },
      { "Open Hi-Hat",        16, 32, 9, 0, 70, 90, 110, 127, 46, 46, false, false },
      { "Low-Mid Tom",        16, 32, 9, 0, 70, 90, 110, 127, 47, 47, false, false },
      { "Hi-Mid Tom",         16, 32, 9, 0, 70, 90, 110, 127, 48, 48, false, false },
      { "Crash Cymbal 1",     16, 32, 9, 0, 70, 90, 110, 127, 49, 49, false, false },
      { "High Tom",           16, 32, 9, 0, 70, 90, 110, 127, 50, 50, false, false },

      { "Ride Cymbal 1",      16, 32, 9, 0, 70, 90, 110, 127, 51, 51, false, false },
      { "Chinese Cymbal",     16, 32, 9, 0, 70, 90, 110, 127, 52, 52, false, false },
      { "Ride Bell",          16, 32, 9, 0, 70, 90, 110, 127, 53, 53, false, false },
      { "Tambourine",         16, 32, 9, 0, 70, 90, 110, 127, 54, 54, false, false },
      { "Splash Cymbal",      16, 32, 9, 0, 70, 90, 110, 127, 55, 55, false, false },
      { "Cowbell",            16, 32, 9, 0, 70, 90, 110, 127, 56, 56, false, false },
      { "Crash Cymbal 2",     16, 32, 9, 0, 70, 90, 110, 127, 57, 57, false, false },
      { "Vibraslap",          16, 32, 9, 0, 70, 90, 110, 127, 58, 58, false, false },
      { "Ride Cymbal 2",      16, 32, 9, 0, 70, 90, 110, 127, 59, 59, false, false },
      { "Hi Bongo",           16, 32, 9, 0, 70, 90, 110, 127, 60, 60, false, false },
      { "Low Bongo",          16, 32, 9, 0, 70, 90, 110, 127, 61, 61, false, false },
      { "Mute Hi Conga",      16, 32, 9, 0, 70, 90, 110, 127, 62, 62, false, false },
      { "Open Hi Conga",      16, 32, 9, 0, 70, 90, 110, 127, 63, 63, false, false },
      { "Low Conga",          16, 32, 9, 0, 70, 90, 110, 127, 64, 64, false, false },
      { "High Timbale",       16, 32, 9, 0, 70, 90, 110, 127, 65, 65, false, false },
      { "Low Timbale",        16, 32, 9, 0, 70, 90, 110, 127, 66, 66, false, false },

      { "High Agogo",         16, 32, 9, 0, 70, 90, 110, 127, 67, 67, false, false },
      { "Low Agogo",          16, 32, 9, 0, 70, 90, 110, 127, 68, 68, false, false },
      { "Cabasa",             16, 32, 9, 0, 70, 90, 110, 127, 69, 69, false, false },
      { "Maracas",            16, 32, 9, 0, 70, 90, 110, 127, 70, 70, false, false },
      { "Short Whistle",      16, 32, 9, 0, 70, 90, 110, 127, 71, 71, false, false },
      { "Long Whistle",       16, 32, 9, 0, 70, 90, 110, 127, 72, 72, false, false },
      { "Short Guiro",        16, 32, 9, 0, 70, 90, 110, 127, 73, 73, false, false },
      { "Long Guiro",         16, 32, 9, 0, 70, 90, 110, 127, 74, 74, false, false },
      { "Claves",             16, 32, 9, 0, 70, 90, 110, 127, 75, 75, false, false },
      { "Hi Wood Block",      16, 32, 9, 0, 70, 90, 110, 127, 76, 76, false, false },
      { "Low Wood Block",     16, 32, 9, 0, 70, 90, 110, 127, 77, 77, false, false },
      { "Mute Cuica",         16, 32, 9, 0, 70, 90, 110, 127, 78, 78, false, false },
      { "Open Cuica",         16, 32, 9, 0, 70, 90, 110, 127, 79, 79, false, false },
      { "Mute Triangle",      16, 32, 9, 0, 70, 90, 110, 127, 80, 80, false, false },
      { "Open Triangle",      16, 32, 9, 0, 70, 90, 110, 127, 81, 81, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 82, 82, false, false },

      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 83, 83, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 84, 84, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 85, 85, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 86, 86, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 87, 87, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 88, 88, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 89, 89, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 90, 90, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 91, 91, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 92, 92, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 93, 93, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 94, 94, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 95, 95, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 96, 96, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 97, 97, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 98, 98, false, false },

      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 83, 83, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 84, 84, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 85, 85, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 86, 86, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 87, 87, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 88, 88, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 89, 89, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 90, 90, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 91, 91, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 92, 92, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 93, 93, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 94, 94, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 95, 95, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 96, 96, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 97, 97, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 98, 98, false, false },

      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 83, 83, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 84, 84, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 85, 85, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 86, 86, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 87, 87, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 88, 88, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 89, 89, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 90, 90, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 91, 91, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 92, 92, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 93, 93, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 94, 94, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 95, 95, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 96, 96, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 97, 97, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 98, 98, false, false },

      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 83, 83, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 84, 84, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 85, 85, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 86, 86, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 87, 87, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 88, 88, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 89, 89, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 90, 90, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 91, 91, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 92, 92, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 93, 93, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 94, 94, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 95, 95, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 96, 96, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 97, 97, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 98, 98, false, false },

      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 83, 83, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 84, 84, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 85, 85, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 86, 86, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 87, 87, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 88, 88, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 89, 89, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 90, 90, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 91, 91, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 92, 92, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 93, 93, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 94, 94, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 95, 95, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 96, 96, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 97, 97, false, false },
      { "",                   16, 32, 9, 0, 70, 90, 110, 127, 98, 98, false, false },
      };

//---------------------------------------------------------
//   initDrumMap
//    populate Inmap and Outmap
//---------------------------------------------------------

void initDrumMap()
      {
      for (int i = 0; i < DRUM_MAPSIZE; ++i)
            drumMap[i] = idrumMap[i];
      memset(drumInmap, 0, sizeof(drumInmap));
      memset(drumOutmap, 0, sizeof(drumOutmap));
      for (int i = 0; i < DRUM_MAPSIZE; ++i) {
            drumInmap[drumMap[i].enote] = i;
            drumOutmap[drumMap[i].anote] = i;
            }
      }

//---------------------------------------------------------
//   operator ==
//---------------------------------------------------------

bool const DrumMap::operator==(const DrumMap& map) const
      {
      return
         (name == map.name)
         && quant == map.quant
         && len == map.len
         && channel == map.channel
         && port == map.port
         && lv1 == map.lv1
         && lv2 == map.lv2
         && lv3 == map.lv3
         && lv4 == map.lv4
         && enote == map.enote
         && anote == map.anote
         && mute == map.mute
         && selected == map.selected;
      }

//---------------------------------------------------------
//   writeDrumMap
//---------------------------------------------------------

void writeDrumMap(int level, Xml& xml, bool external)
      {
      xml.tag(level++, "drummap");
      for (int i = 0; i < DRUM_MAPSIZE; ++i) {
            DrumMap* dm = &drumMap[i];
            const DrumMap* idm = &idrumMap[i];

            if (external) {
                  xml.tag(level++, "entry");
                  xml.strTag(level, "name", dm->name);
                  xml.intTag(level, "quant", dm->quant);
                  xml.intTag(level, "len", dm->len);
                  xml.intTag(level, "channel", dm->channel);
                  xml.intTag(level, "port", dm->port);
                  xml.intTag(level, "lv1", dm->lv1);
                  xml.intTag(level, "lv2", dm->lv2);
                  xml.intTag(level, "lv3", dm->lv3);
                  xml.intTag(level, "lv4", dm->lv4);
                  xml.intTag(level, "enote", dm->enote);
                  xml.intTag(level, "anote", dm->anote);
                  }
            else {
                  // write only, if entry is different from initial entry
                  if (!external && *dm == *idm)
                        continue;
                  xml.tag(level++, "entry idx=\"%d\"", i);
                  if (dm->name != idm->name)
                        xml.strTag(level, "name", dm->name);
                  if (dm->quant != idm->quant)
                        xml.intTag(level, "quant", dm->quant);
                  if (dm->len != idm->len)
                        xml.intTag(level, "len", dm->len);
                  if (dm->channel != idm->channel)
                        xml.intTag(level, "channel", dm->channel);
                  if (dm->port != idm->port)
                        xml.intTag(level, "port", dm->port);
                  if (dm->lv1 != idm->lv1)
                        xml.intTag(level, "lv1", dm->lv1);
                  if (dm->lv2 != idm->lv2)
                        xml.intTag(level, "lv2", dm->lv2);
                  if (dm->lv3 != idm->lv3)
                        xml.intTag(level, "lv3", dm->lv3);
                  if (dm->lv4 != idm->lv4)
                        xml.intTag(level, "lv4", dm->lv4);
                  if (dm->enote != idm->enote)
                        xml.intTag(level, "enote", dm->enote);
                  if (dm->anote != idm->anote)
                        xml.intTag(level, "anote", dm->anote);
                  if (dm->mute != idm->mute)
                        xml.intTag(level, "mute", dm->mute);
                  if (dm->selected != idm->selected)
                        xml.intTag(level, "selected", dm->selected);
                  }
            xml.tag(level--, "/entry");
            }
      xml.tag(level--, "/drummap");
      }

//---------------------------------------------------------
//   readDrummapEntry
//---------------------------------------------------------

static void readDrummapEntry(Xml& xml, DrumMap* dm)
      {
      for (;;) {
            Xml::Token token = xml.parse();
            const QString& tag = xml.s1();
            switch (token) {
                  case Xml::Error:
                  case Xml::End:
                        return;
                  case Xml::TagStart:
                        if (tag == "name")
                              dm->name = xml.parse("name");
                        else if (tag == "quant")
                              dm->quant = xml.parseInt();
                        else if (tag == "len")
                              dm->len = xml.parseInt();
                        else if (tag == "channel")
                              dm->channel = xml.parseInt();
                        else if (tag == "port")
                              dm->port = xml.parseInt();
                        else if (tag == "lv1")
                              dm->lv1 = xml.parseInt();
                        else if (tag == "lv2")
                              dm->lv2 = xml.parseInt();
                        else if (tag == "lv3")
                              dm->lv3 = xml.parseInt();
                        else if (tag == "lv4")
                              dm->lv4 = xml.parseInt();
                        else if (tag == "enote")
                              dm->enote = xml.parseInt();
                        else if (tag == "anote")
                              dm->anote = xml.parseInt();
                        else if (tag == "mute")
                              dm->mute = xml.parseInt();
                        else if (tag == "selected")
                              dm->selected = xml.parseInt();
                        else
                              xml.unknown("DrumMapEntry");
                        break;
                  case Xml::Attribut:
                        if (tag == "idx") {
                              int idx = xml.s2().toInt();
                              dm = &drumMap[idx];
                              }
                        break;
                  case Xml::TagEnd:
                        if (tag == "entry")
                              return;
                  default:
                        break;
                  }
            }
      }

//---------------------------------------------------------
//   readDrummap
//---------------------------------------------------------

void readDrumMap(Xml& xml, bool external)
      {
      if (external) {
            const DrumMap* dm = &idrumMap[DRUM_MAPSIZE-1];
            for (int i = 0; i < DRUM_MAPSIZE; ++i)
                  drumMap[i] = *dm;
            }
      else {
            for (int i = 0; i < DRUM_MAPSIZE; ++i)
                  drumMap[i] = idrumMap[i];
            }
      int i = 0;
      for (;;) {
            Xml::Token token = xml.parse();
            const QString& tag = xml.s1();
            switch (token) {
                  case Xml::Error:
                  case Xml::End:
                        return;
                  case Xml::TagStart:
                        if (tag == "entry") {
                              readDrummapEntry(xml, external ? &drumMap[i] : 0);
                              ++i;
                              }
                        else if (tag == "comment")
                              xml.parse();
                        else
                              xml.unknown("DrumMap");
                        break;
                  case Xml::Attribut:
                        break;
                  case Xml::TagEnd:
                        if (tag == "drummap") {
                              memset(drumInmap, 0, sizeof(drumInmap));
                              memset(drumOutmap, 0, sizeof(drumOutmap));
                              for (int i = 0; i < DRUM_MAPSIZE; ++i) {
                                    drumInmap[drumMap[i].enote] = i;
                                    drumOutmap[drumMap[i].anote] = i;
                                    }
                              return;
                              }
                  default:
                        break;
                  }
            }
      }

