//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: memory.cpp,v 1.1 2002/01/30 14:54:03 muse Exp $
//
//    memory debugging utilities
//    (not thread safe!)
//
//  (C) Copyright 2001 Werner Schweer (ws@seh.de)
//=========================================================

// #define MEMORY_DEBUG

#ifdef MEMORY_DEBUG

#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include "memory.h"
#include "string.h"

static void my_init_hook();
static void* my_malloc_hook (size_t, const void *);
static void my_free_hook (void*, const void *);
static void* my_realloc_hook(void*, size_t, const void *);

void (*__malloc_initialize_hook)() = my_init_hook;
static void* (*old_malloc_hook)(size_t, const void*);
static void (*old_free_hook)(void*, const void*);

static int bMAGIC = 0x12345678;
static int eMAGIC = 0x87654321;

struct MH {
      MH* prev;
      MH* next;
      int sn;
      int n;
      int magic;
      };

static MH* head;
static int sn = 0;

//---------------------------------------------------------
//   check
//---------------------------------------------------------

static void check(MH* mh)
      {
      if (mh->magic != bMAGIC) {
            printf("%d Anfang berschrieben %08x, len %d, sn %d\n",
               sn, mh->magic, mh->n, mh->sn);
            abort();
            }
      char* p = (char*)mh + sizeof(MH);
      if (*(int*)(p+mh->n) != eMAGIC) {
            printf("%d Ende berschrieben %08x, len %d, sn %d\n",
               sn, *(int*)(p+mh->n), mh->n, mh->sn);
            abort();
            }
      }

//---------------------------------------------------------
//   checkChain
//---------------------------------------------------------

static bool checkChain(MH* p)
      {
      MH* mh = head;
      bool notfound = true;
//printf("CHECK %d 0x%08x\n", sn, p);
      while (mh) {
            if (p == mh)
                  notfound = false;
            check(mh);
            mh = mh->prev;
            }
      return notfound;
      }

//---------------------------------------------------------
//   checkMemoryChain
//---------------------------------------------------------

void checkMemoryChain(void* _p)
      {
      bool notfound = true;
      MH* p  = (MH*)((char*)_p - sizeof(MH));
      MH* mh = head;
      while (mh) {
            if (p == mh)
                  notfound = false;
            check(mh);
            mh = mh->prev;
            }
      if (notfound) {
            printf("%d not allocated %p, len %d, sn %d\n",
               sn, _p, p->n, p->sn);
            }
      }

//---------------------------------------------------------
//   my_malloc
//---------------------------------------------------------

static void* my_malloc(int n)
      {
      char* p  = (char*)malloc(n + sizeof(int) + sizeof(MH));

      memset(p, 0xff, n + sizeof(int) + sizeof(MH));

//printf("NEW %d  %d\n", sn, n);

      MH* mh    = (MH*)p;

      mh->sn    = sn++;
      mh->n     = n;
      mh->magic = bMAGIC;
      p += sizeof(MH);
      *(int*)(p+n) = eMAGIC;
      mh->prev     = head;
      mh->next     = 0;
      if (head)
            head->next = mh;
      head = mh;
//      checkChain(0);
      return p;
      }

//---------------------------------------------------------
//   my_free
//---------------------------------------------------------

static void my_free(void* _p)
      {
      if (_p == 0) {
            printf("memory check: try to free 0\n");
            return;
            }
      char* p = (char*)_p;
      MH* mh  = (MH*)(p - sizeof(MH));

      check(mh);
#if 0
      if (checkChain(mh)) {
            printf("free without malloc 0x%x\n", p);
            abort();
            }
#endif
      return;     // DEBUG: no free

      if (mh->next == 0) {
            head = mh->prev;
            mh->prev->next = 0;
            }
      else {
            if (mh->prev)
                  mh->prev->next = mh->next;
            if (mh->next)
                  mh->next->prev = mh->prev;
            }
//      int n   = mh->n;
//      printf("FREE %d %d\n", ip[-3], n);
//            printf("%d free %x n\n", mh->sn, _p, mh->n);
      free(mh);
      }

//---------------------------------------------------------
//   my_init_hook
//---------------------------------------------------------

static void my_init_hook (void)
      {
      old_malloc_hook = __malloc_hook;
      old_free_hook   = __free_hook;

      __malloc_hook   = my_malloc_hook;
      __realloc_hook  = my_realloc_hook;
      __free_hook     = my_free_hook;
      }

//---------------------------------------------------------
//   my_realloc_hook
//---------------------------------------------------------

static void* my_realloc_hook(void* ptr, size_t n, const void*)
      {
      __malloc_hook   = old_malloc_hook;
      __free_hook     = old_free_hook;

      int* np;
      if (ptr == 0)
            np = (int*)my_malloc(n);
      else {
            MH* mh   = (MH*) ((char*)ptr-sizeof(MH));
            unsigned int oldn = mh->n;
            if (oldn == n)
                  return ptr;
            np  = (int*)my_malloc(n);
            int nn   = (n < oldn) ? n : oldn;
            memcpy(np, ptr, nn);
            my_free(ptr);
            }
      old_malloc_hook = __malloc_hook;
      old_free_hook   = __free_hook;
      __malloc_hook   = my_malloc_hook;
      __free_hook     = my_free_hook;
      return np;
      }

//---------------------------------------------------------
//   my_malloc_hook
//---------------------------------------------------------

static void* my_malloc_hook (size_t size, const void *)
      {
      __malloc_hook   = old_malloc_hook;
      __free_hook     = old_free_hook;

      void* result    = my_malloc(size);

      old_malloc_hook = __malloc_hook;
      old_free_hook   = __free_hook;

      __malloc_hook   = my_malloc_hook;
      __free_hook     = my_free_hook;
      return result;
      }

//---------------------------------------------------------
//   my_free_hook
//---------------------------------------------------------

static void my_free_hook (void* ptr, const void* /*caller*/)
      {
      __malloc_hook   = old_malloc_hook;
      __free_hook     = old_free_hook;

      my_free(ptr);

      old_malloc_hook = __malloc_hook;
      old_free_hook   = __free_hook;
      __malloc_hook   = my_malloc_hook;
      __free_hook     = my_free_hook;
      }
#endif

