//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: audioprefetch.h,v 1.2 2001/11/20 15:19:31 muse Exp $
//
//  (C) Copyright 2001 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __AUDIOPREFETCH_H__
#define __AUDIOPREFETCH_H__

#include "thread.h"


enum { PREFETCH_TICK
      };

struct PrefetchMsg : public ThreadMsg {
      int pos;
      int bufferNo;
      };

//---------------------------------------------------------
//   AudioThread
//---------------------------------------------------------

class AudioPrefetch : public Thread {
      int currentFrameSize;

      virtual void processMsg1(const void*);
      void prefetch(int pos, int bufferNo);

   public:
      AudioPrefetch(bool rt=true, int prio=50, bool ml = true);
      ~AudioPrefetch();
      virtual void start();

      void msgTick(int samplePos, int bufferNo);
      };

#endif
