//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: audiomix.cpp,v 1.1 2002/01/30 14:54:03 muse Exp $
//
//  (C) Copyright 2000 Werner Schweer (ws@seh.de)
//=========================================================

#include "audiomix.h"
#include "globals.h"
#include "xml.h"

#define MIN(a,b) (a)>(b)?(b):(a)

//---------------------------------------------------------
//   AudioFifo
//---------------------------------------------------------

void AudioFifo::setup(int buffers, int bsize)
      {
      if (data) {
            for (int i = 0; i < size; ++i)
                  delete data[i];
            delete data;
            }
      head = tail = used = 0;
      size = buffers;
      data = new float*[size];
      for (int i = 0; i < size; ++i)
            data[i] = new float[bsize];
      }

//---------------------------------------------------------
//   ~AudioFifo
//---------------------------------------------------------

AudioFifo::~AudioFifo()
      {
      if (data) {
            for (int i = 0; i < size; ++i)
                  delete data[i];
            delete data;
            }
      }

//---------------------------------------------------------
//   getFreeBuffer
//---------------------------------------------------------

float* AudioFifo::getFreeBuffer()
      {
      if (used == size)
            return 0;
      return data[tail];
      }

//---------------------------------------------------------
//   writeBuffer
//---------------------------------------------------------

void AudioFifo::writeBuffer()
      {
      ++tail;
      tail %= size;
      ++used;
      }

//---------------------------------------------------------
//   fillBuffer
//---------------------------------------------------------

void AudioFifo::getData(float* buffer, int /*idx*/)
     {
     int n = sizeof(float) * channels() * segmentSize;
      if (used == 0) {
            printf("AudioFifo::getData(): underrun\n");
            memset(buffer, 0, n);
            return;
            }
      memcpy(buffer, data[head], n);
      ++head;
      head %= size;
      --used;
      }

//---------------------------------------------------------
//   AudioMixer
//---------------------------------------------------------

AudioMixer::AudioMixer()
      {
      }

//---------------------------------------------------------
//   ~AudioMixer
//---------------------------------------------------------

AudioMixer::~AudioMixer()
      {
      }

//---------------------------------------------------------
//   getData
//    mixing
//---------------------------------------------------------

void AudioMixer::getData(float* buffer, int idx)
      {
      memset(buffer, 0, channels() * segmentSize * sizeof(float));
      for (iAudioNode i = inputs.begin(); i != inputs.end(); ++i)
            (*i)->fillBuffer(channels(), buffer, idx);
      }

//---------------------------------------------------------
//   connect
//    add audio source to mixer object
//---------------------------------------------------------

void AudioMixer::connect(AudioNode* as)
      {
      if (as == 0)
            return;
      for (iAudioNode src = inputs.begin(); src != inputs.end(); ++src) {
            if (*src == as)
                  return;
            }
      inputs.push_back(as);
      }

//---------------------------------------------------------
//   removeSource
//    remove audio source from mixer object
//---------------------------------------------------------

void AudioMixer::disconnect(AudioNode* as)
      {
      for (iAudioNode src = inputs.begin(); src != inputs.end(); ++src) {
            if (*src == as) {
                  inputs.erase(src);
                  return;
                  }
            }
      printf("AudioMixer::disconnect(): not found\n");
      }
