//=========================================================
//  MusE
//  Linux Music Editor
//    $Id: arranger.h,v 1.3 2001/12/04 09:36:17 muse Exp $
//  (C) Copyright 1999 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __ARRANGER_H__
#define __ARRANGER_H__

#include <qwidget.h>
#include <qheader.h>
#include <qwhatsthis.h>

#include "midieditor.h"
#include "progname.h"
#include "pcanvas.h"
#include "ssource.h"

class QToolButton;
class Header;
class TList;
class ScrollScale;
class MTScale;
class IntLabel;
class QLineEdit;
class LabelEntry;
class Track;
class Xml;
class QComboBox;
class Splitter;
class LabelCombo;
class QLabel;
class PosLabel;
class QCheckBox;
class QSpinBox;
class TrackInfoBase;

class TWhatsThis : public QWhatsThis {
      Header* header;
   protected:
      QString text(const QPoint&);
   public:
      TWhatsThis(QWidget* parent, Header* h) : QWhatsThis(parent) {
            header = h;
            }
      };

//---------------------------------------------------------
//   Arranger
//---------------------------------------------------------

class Arranger : public QWidget {
      int _quant, _raster;
      PartCanvas* canvas;
      ScrollScale* hscroll;
      ScrollScale* vscroll;
      TList* list;
      Header* header;
      MTScale* time;
      QSpinBox* lenEntry;
      bool showTrackinfo;

      TrackInfoBase* midiTrackInfo;
      QWidget* waveTrackInfo;
      QWidget* noTrackInfo;

      QLineEdit* iwName;
      QLabel* ifName;
      QComboBox* iChannels;

      QCheckBox* midiThru;

      Track* selected;
      QToolButton* solo;

      LabelCombo* typeBox;
      QToolButton* ib;
      int trackInfoType;
      Splitter* split;
      QPopupMenu* pop;
      QPopupMenu* subPop[PROG_GROUPS];
      int songType;
      QString _bgPixmap;
      PosLabel* cursorPos;

      int trackInfoSize;

      Q_OBJECT
      void genTrackInfo(QWidget* parent);
      void genMidiTrackInfo();
      void genWaveTrackInfo();
      void updateMidiTrackInfo();
      void updateWaveTrackInfo();
      void updateNoTrackInfo();

   private slots:
      void _setRaster(int);
      void songlenChanged(int);
      void showInspector(bool);
      void trackSelectionChanged();

      void iNameChanged();
      void nameChanged(const QString&);
      void iHBankChanged(int);
      void iLBankChanged(int);
      void iInputChannelChanged(const QString&);
      void iOutputChannelChanged(int);
      void iInputPortChanged(const QString&);
      void iOutputPortChanged(int);
      void iProgramChanged(int);
      void iLautstChanged(int);
      void iTranspChanged(int);
      void iAnschlChanged(int);
      void iVerzChanged(int);
      void iLenChanged(int);
      void iKomprChanged(int);
      void iPanChanged(int);
      void updateInspector();
      void setPartColor(int);
      void songChanged(int);
      void soloChanged(SoundSource*);
      void modeChange(int);
      void instrPopup();
      void iChannelsChanged(int);
//      void iwNameChanged();
      void setTime(int);
      void recFileDialog();
      void midiThruChanged(bool);
      void headerMoved();

   signals:
      void editPart(Track*);
      void soloChanged(bool, Track*);
      void selectionChanged();
      void dropFile(const QString&);
      void startEditor(PartList*, int);

   public slots:
      void dclickPart(Track*);
      void setTool(int);
      void setActivityMode(int);
      void setActivityColor(QColor);
      void setSelectedTrackColor(QColor c);
      void soloChanged(bool flag);

   public:
      enum { CMD_CUT_PART, CMD_COPY_PART, CMD_PASTE_PART };

      Arranger(MainWindow* parent, const char* name = 0);
      void setBgPixmap(const QString&);
      const QString bgPixmap() const { return _bgPixmap; }
      void setMode(int);
      void reset();
      int showPartType() const;
      int showPartEvent() const;
      void setShowPartType(int val);
      void setShowPartEvent(int val);

      void writeStatus(int level, Xml&);
      void readStatus(Xml&);

      Track* curTrack() const { return selected; }
      void cmd(int);
      bool isSingleSelection() { return canvas->isSingleSelection(); }
      int getActivityMode() const;
      QColor getActivityColor() const;
      QColor getSelectedTrackColor() const;
      void setGrid(bool);
      bool hasGrid();
      };
#endif

