#include <stdio.h>
#include <string.h>
#include <sys/time.h>
#include <sys/resource.h>

#define N 100000000

double get_cpu_usage(void)
{
	struct rusage usage;

	if (getrusage(RUSAGE_SELF, &usage) == -1)
		printf("getrusage error\n");

	return (double)usage.ru_utime.tv_sec + (double)usage.ru_utime.tv_usec / 1000000.0 + (double)usage.ru_stime.tv_sec + (double)usage.ru_stime.tv_usec / 1000000.0;
}

void *mymalloc(int n, char *what)
{
	void *p = malloc(n);
	if (!p)
		printf("error1\n");

	return p;
}

void test(int inlen)
{
	int loop;
	char *in = malloc(inlen);
	char *what = "blaasdasd";
	double start;
	FILE *flog = fopen("strdup-test.log", "a+");

	memset(in, 0x13, inlen);
	in[inlen - 1] = 0x00;

	fprintf(flog, "%d ", inlen);

	start = get_cpu_usage();
	for(loop=0; loop<N; loop++)
	{
		int len = strlen(in) + 1;
		char *newp = (char *)mymalloc(len, what);

		memcpy(newp, in, len);

		free(newp);
	}
	fprintf(flog, "%f ", get_cpu_usage() - start);

	start = get_cpu_usage();
	for(loop=0; loop<N; loop++)
	{
		char *newp = strdup(in);
		if (!newp)
			printf("error2\n");
		free(newp);
	}
	fprintf(flog, "%f\n", get_cpu_usage() - start);
	fclose(flog);
}

int main(int argc, char *argv[])
{
	int loop;

	for(loop=2; loop<1024; loop++)
	{
		test(loop);
	}

	return 0;
}
