/*
 * Decompiled with CFR 0.152.
 */
package viewer.zoomable;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import viewer.common.Dialogs;
import viewer.zoomable.Debug;
import viewer.zoomable.ToolBarStatus;
import viewer.zoomable.YaxisTree;

public class ActionTimelineDelete
implements ActionListener {
    private Window root_window;
    private ToolBarStatus toolbar;
    private YaxisTree tree;
    private DefaultTreeModel tree_model;

    public ActionTimelineDelete(Window window, ToolBarStatus toolBarStatus, YaxisTree yaxisTree) {
        this.root_window = window;
        this.toolbar = toolBarStatus;
        this.tree = yaxisTree;
        this.tree_model = (DefaultTreeModel)this.tree.getModel();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        if (Debug.isActive()) {
            Debug.println("Action for Delete Timeline button");
        }
        if (!Dialogs.confirm(this.root_window, "Are you sure to PERMANENTLY delete the marked items?")) {
            return;
        }
        TreePath[] treePathArray = this.tree.getFromCutAndPasteBuffer();
        if (treePathArray.length < 1) {
            Dialogs.warn(this.root_window, "Nothing has been marked for removal!");
            return;
        }
        for (n = 0; n < treePathArray.length; ++n) {
            if (!this.tree.isExpanded(treePathArray[n])) continue;
            if (Debug.isActive()) {
                Debug.println("\tCollapse " + treePathArray[n]);
            }
            this.tree.collapsePath(treePathArray[n]);
        }
        for (n = 0; n < treePathArray.length; ++n) {
            MutableTreeNode mutableTreeNode = (MutableTreeNode)treePathArray[n].getLastPathComponent();
            this.tree_model.removeNodeFromParent(mutableTreeNode);
            if (!Debug.isActive()) continue;
            Debug.println("\tCut " + mutableTreeNode);
        }
        this.tree.clearCutAndPasteBuffer();
        this.tree.update_leveled_paths();
        this.toolbar.getTimelineMarkButton().setEnabled(true);
        this.toolbar.getTimelineMoveButton().setEnabled(false);
        this.toolbar.getTimelineDeleteButton().setEnabled(false);
        this.toolbar.resetYaxisTreeButtons();
    }
}

