/*
 * Decompiled with CFR 0.152.
 */
package old_base.drawable;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import old_base.drawable.ColorAlpha;
import old_base.drawable.InfoType;
import old_base.drawable.Method;
import old_base.drawable.Topology;
import old_base.io.MixedDataIO;
import old_base.io.MixedDataInput;
import old_base.io.MixedDataOutput;

public class Category
implements MixedDataIO {
    private int index;
    private String name;
    private Topology topo;
    private ColorAlpha color;
    private int width;
    private String[] infokeys;
    private InfoType[] infotypes;
    private Method[] methods;
    private boolean hasBeenUsed;
    private boolean isVisible;
    private boolean isSearchable;
    private static final int PREVIEW_EVENT_INDEX = -1;
    private static final int PREVIEW_ARROW_INDEX = -2;
    private static final int PREVIEW_STATE_INDEX = -3;

    public Category() {
        this.infokeys = null;
        this.infotypes = null;
        this.methods = null;
        this.hasBeenUsed = false;
        this.isVisible = true;
        this.isSearchable = true;
    }

    public Category(int n, String string, Topology topology, ColorAlpha colorAlpha, int n2) {
        this.index = n;
        this.name = string;
        this.topo = topology;
        this.color = colorAlpha;
        this.width = n2;
        this.infokeys = null;
        this.infotypes = null;
        this.methods = null;
        this.hasBeenUsed = false;
        this.isVisible = true;
        this.isSearchable = true;
    }

    public Category(int n, String string, int n2) {
        this.index = n;
        this.name = string;
        this.width = n2;
        this.infokeys = null;
        this.infotypes = null;
        this.methods = null;
        this.hasBeenUsed = false;
        this.isVisible = true;
        this.isSearchable = true;
    }

    public int getIndex() {
        return this.index;
    }

    public void setUsed(boolean bl) {
        this.hasBeenUsed = bl;
    }

    public boolean isUsed() {
        return this.hasBeenUsed;
    }

    public void setVisible(boolean bl) {
        this.isVisible = bl;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setSearchable(boolean bl) {
        this.isSearchable = bl;
    }

    public boolean isSearchable() {
        return this.isSearchable;
    }

    public boolean isVisiblySearchable() {
        return this.isVisible && this.isSearchable;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setTopology(Topology topology) {
        this.topo = topology;
    }

    public Topology getTopology() {
        return this.topo;
    }

    public void setColor(ColorAlpha colorAlpha) {
        this.color = colorAlpha;
    }

    public ColorAlpha getColor() {
        return this.color;
    }

    public void setInfoKeys(String string) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "%", true);
            int n = stringTokenizer.countTokens();
            if (n > 0) {
                int n2;
                Iterator iterator;
                ArrayList<String> arrayList = new ArrayList<String>();
                ArrayList<InfoType> arrayList2 = new ArrayList<InfoType>();
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    if (string2.length() == 1 && string2.equals("%")) {
                        String string3 = stringTokenizer.nextToken();
                        arrayList2.add(new InfoType(string3.charAt(0)));
                        string2 = string3.substring(1);
                    }
                    arrayList.add(string2);
                }
                if (arrayList.size() > 0) {
                    this.infokeys = new String[arrayList.size()];
                    iterator = arrayList.iterator();
                    n2 = 0;
                    while (iterator.hasNext()) {
                        this.infokeys[n2] = (String)iterator.next();
                        ++n2;
                    }
                } else {
                    this.infokeys = null;
                }
                if (arrayList2.size() > 0) {
                    this.infotypes = new InfoType[arrayList2.size()];
                    iterator = arrayList2.iterator();
                    n2 = 0;
                    while (iterator.hasNext()) {
                        this.infotypes[n2] = (InfoType)iterator.next();
                        ++n2;
                    }
                } else {
                    this.infotypes = null;
                }
            }
        } else {
            this.infokeys = null;
            this.infotypes = null;
        }
    }

    public String[] getInfoKeys() {
        return this.infokeys;
    }

    public InfoType[] getInfoTypes() {
        return this.infotypes;
    }

    public void setMethodIDs(int[] nArray) {
        if (nArray != null && nArray.length > 0) {
            this.methods = new Method[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                this.methods[i] = new Method(nArray[i]);
            }
        } else {
            this.methods = null;
        }
    }

    public void writeObject(MixedDataOutput mixedDataOutput) throws IOException {
        int n;
        mixedDataOutput.writeInt(this.index);
        mixedDataOutput.writeString(this.name);
        this.topo.writeObject(mixedDataOutput);
        this.color.writeObject(mixedDataOutput);
        mixedDataOutput.writeByte(this.width);
        if (this.infokeys != null && this.infokeys.length > 0) {
            mixedDataOutput.writeShort((short)this.infokeys.length);
            for (n = 0; n < this.infokeys.length; ++n) {
                mixedDataOutput.writeString(this.infokeys[n]);
            }
        } else {
            mixedDataOutput.writeShort(0);
        }
        if (this.infotypes != null && this.infotypes.length > 0) {
            mixedDataOutput.writeShort((short)this.infotypes.length);
            for (n = 0; n < this.infotypes.length; ++n) {
                this.infotypes[n].writeObject(mixedDataOutput);
            }
        } else {
            mixedDataOutput.writeShort(0);
        }
        if (this.methods != null && this.methods.length > 0) {
            mixedDataOutput.writeShort((short)this.methods.length);
            for (n = 0; n < this.methods.length; ++n) {
                this.methods[n].writeObject(mixedDataOutput);
            }
        } else {
            mixedDataOutput.writeShort(0);
        }
    }

    public Category(MixedDataInput mixedDataInput) throws IOException {
        this();
        this.readObject(mixedDataInput);
    }

    public void readObject(MixedDataInput mixedDataInput) throws IOException {
        int n;
        this.index = mixedDataInput.readInt();
        this.name = mixedDataInput.readString();
        this.topo = new Topology(mixedDataInput);
        this.color = new ColorAlpha(mixedDataInput);
        this.width = mixedDataInput.readByte();
        int n2 = mixedDataInput.readShort();
        if (n2 > 0) {
            this.infokeys = new String[n2];
            for (n = 0; n < n2; ++n) {
                this.infokeys[n] = mixedDataInput.readString();
            }
        } else {
            this.infokeys = null;
        }
        if ((n2 = mixedDataInput.readShort()) > 0) {
            this.infotypes = new InfoType[n2];
            for (n = 0; n < n2; ++n) {
                this.infotypes[n] = new InfoType(mixedDataInput);
            }
        } else {
            this.infotypes = null;
        }
        if ((n2 = mixedDataInput.readShort()) > 0) {
            this.methods = new Method[n2];
            for (n = 0; n < n2; ++n) {
                this.methods[n] = new Method(mixedDataInput);
            }
        } else {
            this.methods = null;
        }
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("Category[ ");
        stringBuffer.append("index=" + this.index + ", name=" + this.name + ", topo=" + this.topo + ", color=" + this.color + ", isUsed=" + this.hasBeenUsed + ", width=" + this.width);
        if (this.infokeys != null && this.infokeys.length > 0 || this.infotypes != null && this.infotypes.length > 0) {
            stringBuffer.append(", info_fmt=< ");
            int n2 = this.infokeys != null ? this.infokeys.length : 0;
            int n3 = this.infotypes != null ? this.infotypes.length : 0;
            int n4 = Math.max(n2, n3);
            for (n = 0; n < n4; ++n) {
                if (n < n2) {
                    stringBuffer.append(this.infokeys[n]);
                }
                if (n >= n3) continue;
                stringBuffer.append(this.infotypes[n]);
            }
            stringBuffer.append(" >");
        }
        if (this.methods != null && this.methods.length > 0) {
            stringBuffer.append(", methods=< ");
            for (n = 0; n < this.methods.length; ++n) {
                stringBuffer.append(this.methods[n] + " ");
            }
            stringBuffer.append(">");
        }
        stringBuffer.append(", vis=" + this.isVisible);
        stringBuffer.append(", search=" + this.isSearchable);
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }

    public boolean isShadowCategory() {
        return this.index < 0;
    }

    public static Category getShadowCategory(Topology topology) {
        if (topology.isEvent()) {
            Category category = new Category(-1, "Preview_" + topology.toString(), topology, ColorAlpha.WHITE_NEAR_OPAQUE, 5);
            return category;
        }
        if (topology.isArrow()) {
            Category category = new Category(-2, "Preview_" + topology.toString(), topology, ColorAlpha.YELLOW_OPAQUE, 5);
            return category;
        }
        if (topology.isState()) {
            Category category = new Category(-3, "Preview_" + topology.toString(), topology, ColorAlpha.WHITE_NEAR_OPAQUE, 5);
            return category;
        }
        return null;
    }
}

