/*
 * Decompiled with CFR 0.152.
 */
package viewer.common;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import viewer.common.LabeledTextField;

public class LabeledFloatSlider
extends LabeledTextField
implements ChangeListener,
ActionListener {
    private static final long serialVersionUID = 1300L;
    private static final int SLIDER_MIN = 0;
    private static final int SLIDER_MAX = 10000;
    private static final int SLIDER_EXTENT = 10000;
    private JSlider slider;
    private float fmin;
    private float fmax;
    private float fextent;

    public LabeledFloatSlider(String string, float f, float f2) {
        super(true, string, "0.0##");
        this.fmin = f;
        this.fmax = f2;
        this.fextent = this.fmax - this.fmin;
        int n = 5000;
        this.slider = new JSlider(0, 0, 10000, n);
        this.slider.setPaintLabels(true);
        float f3 = this.ivalue2flabel(n);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        JLabel jLabel = new JLabel(this.fmt.format(this.fmin));
        if (FONT != null) {
            jLabel.setFont(FONT);
        }
        hashtable.put(new Integer(0), jLabel);
        jLabel = new JLabel(this.fmt.format(f3));
        if (FONT != null) {
            jLabel.setFont(FONT);
        }
        hashtable.put(new Integer(n), jLabel);
        jLabel = new JLabel(this.fmt.format(this.fmax));
        if (FONT != null) {
            jLabel.setFont(FONT);
        }
        hashtable.put(new Integer(10000), jLabel);
        this.slider.setLabelTable(hashtable);
        this.slider.setBorder(BorderFactory.createLoweredBevelBorder());
        this.slider.setAlignmentX(0.0f);
        this.slider.addChangeListener(this);
        super.addActionListener(this);
        super.add(this.slider);
    }

    private float ivalue2flabel(int n) {
        return this.fextent / 10000.0f * (float)(n - 0) + this.fmin;
    }

    private int flabel2ivalue(float f) {
        return Math.round(10000.0f / this.fextent * (f - this.fmin)) + 0;
    }

    public void setFloat(float f) {
        int n = this.flabel2ivalue(f);
        if (n <= 0) {
            n = 1;
            f = this.ivalue2flabel(n);
        }
        if (n >= 10000) {
            n = 9999;
            f = this.ivalue2flabel(n);
        }
        super.setFloat(f);
        this.slider.setValue(n);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        int n = this.slider.getValue();
        if (n <= 0) {
            n = 1;
            this.slider.setValue(n);
        }
        if (n >= 10000) {
            n = 9999;
            this.slider.setValue(n);
        }
        float f = this.ivalue2flabel(n);
        super.setFloat(f);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        float f = super.getFloat();
        int n = this.flabel2ivalue(f);
        if (n <= 0) {
            n = 1;
            super.setFloat(this.ivalue2flabel(n));
        }
        if (n >= 10000) {
            n = 9999;
            super.setFloat(this.ivalue2flabel(n));
        }
        this.slider.setValue(n);
    }
}

