/*
 * Decompiled with CFR 0.152.
 */
package base.drawable;

import base.drawable.Category;
import base.drawable.CategorySummary;
import base.io.DataIO;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Comparator;
import java.util.Map;

public class CategoryWeight
extends CategorySummary
implements DataIO {
    public static final int BYTESIZE = 20;
    public static final Comparator INDEX_ORDER = new IndexOrder();
    private static final int INVALID_INDEX = Integer.MIN_VALUE;
    private int type_idx;
    private Category type;
    private int width;
    private int height;

    public CategoryWeight() {
        this.type = null;
        this.type_idx = Integer.MIN_VALUE;
        this.width = 0;
        this.height = 0;
    }

    public CategoryWeight(Category category, float f, float f2, long l) {
        super(f, f2, l);
        this.type = category;
        this.type_idx = this.type.getIndex();
    }

    public CategoryWeight(CategoryWeight categoryWeight) {
        super(categoryWeight);
        this.type = categoryWeight.type;
        this.type_idx = categoryWeight.type_idx;
    }

    public void setPixelWidth(int n) {
        this.width = n;
    }

    public int getPixelWidth() {
        return this.width;
    }

    public void setPixelHeight(int n) {
        this.height = n;
    }

    public int getPixelHeight() {
        return this.height;
    }

    public Category getCategory() {
        return this.type;
    }

    public boolean resolveCategory(Map map) {
        if (this.type == null && this.type_idx != Integer.MIN_VALUE) {
            this.type = (Category)map.get(new Integer(this.type_idx));
            if (this.type != null) {
                return true;
            }
        }
        return false;
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.type_idx);
        super.writeObject(dataOutput);
    }

    public CategoryWeight(DataInput dataInput) throws IOException {
        this.readObject(dataInput);
    }

    public void readObject(DataInput dataInput) throws IOException {
        this.type_idx = dataInput.readInt();
        super.readObject(dataInput);
    }

    public String toInfoBoxString(int n) {
        StringBuffer stringBuffer = new StringBuffer("legend=");
        if (this.type != null) {
            stringBuffer.append(this.type.getName());
        } else {
            stringBuffer.append("null:" + this.type_idx);
        }
        stringBuffer.append(", ");
        stringBuffer.append(super.toInfoBoxString(n));
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("(type=" + this.type_idx);
        if (this.type != null) {
            stringBuffer.append(":" + this.type.getName());
        } else {
            stringBuffer.append(", ");
        }
        stringBuffer.append(super.toString());
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private static class IndexOrder
    implements Comparator {
        private IndexOrder() {
        }

        public int compare(Object object, Object object2) {
            CategoryWeight categoryWeight = (CategoryWeight)object;
            CategoryWeight categoryWeight2 = (CategoryWeight)object2;
            return categoryWeight.type_idx - categoryWeight2.type_idx;
        }
    }
}

