/*
 * Decompiled with CFR 0.152.
 */
package base.topology;

import base.drawable.CoordPixelXform;
import base.drawable.TimeBoundingBox;
import base.statistics.CategoryTimeBox;
import base.statistics.TimeAveBox;
import base.topology.StateBorder;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.Arrays;

public class SummaryState {
    private static StateBorder BorderStyle = StateBorder.WHITE_RAISED_BORDER;
    private static StateBorder BackBorder = StateBorder.COLOR_XOR_BORDER;
    private static Color BackColor = Color.black;
    public static Color ForeColor = Color.white;
    public static final String FIT_MOST_LEGENDS = "FitMostLegends";
    private static final int FIT_MOST_LEGENDS_ID = 0;
    public static final String OVERLAP_INCLUSION = "OverlapInclusionRatio";
    private static final int OVERLAP_INCLUSION_ID = 1;
    public static final String OVERLAP_EXCLUSION = "OverlapExclusionRatio";
    private static final int OVERLAP_EXCLUSION_ID = 3;
    public static final String CUMULATIVE_EXCLUSION = "CumulativeExclusionRatio";
    private static final int CUMULATIVE_EXCLUSION_ID = 4;
    private static int DisplayType = 1;
    private static int MinCategoryHeight = 2;
    private static int MinCategorySeparation = 4;

    public static void setBorderStyle(StateBorder stateBorder) {
        BorderStyle = stateBorder;
    }

    public static void setBackgroundColor(Color color) {
        BackColor = color;
        ForeColor = BackColor == Color.black ? Color.lightGray : (BackColor == Color.white ? Color.darkGray : (BackColor == Color.darkGray ? Color.white : (BackColor == Color.lightGray ? Color.darkGray : Color.white)));
    }

    public static void setDisplayType(String string) {
        DisplayType = string.equals(FIT_MOST_LEGENDS) ? 0 : (string.equals(OVERLAP_INCLUSION) ? 1 : (string.equals(OVERLAP_EXCLUSION) ? 3 : (string.equals(CUMULATIVE_EXCLUSION) ? 4 : 1)));
    }

    public static boolean isDisplayTypeEqualWeighted() {
        return DisplayType == 0;
    }

    public static boolean isDisplayTypeExclusiveRatio() {
        return DisplayType == 3 || DisplayType == 4;
    }

    public static boolean isDisplayTypeCumulative() {
        return DisplayType == 4;
    }

    public static void setMinCategoryHeight(int n) {
        MinCategoryHeight = n;
    }

    private static int drawForward(Graphics2D graphics2D, Color color, CoordPixelXform coordPixelXform, double d, float f, double d2, float f2) {
        int n = coordPixelXform.convertTimeToPixel(d);
        int n2 = coordPixelXform.convertTimeToPixel(d2);
        int n3 = coordPixelXform.convertRowToPixel(f);
        int n4 = coordPixelXform.convertRowToPixel(f2);
        boolean bl = n >= 0;
        boolean bl2 = n2 < coordPixelXform.getImageWidth();
        int n5 = bl ? n : 0;
        int n6 = n3;
        int n7 = bl2 ? n2 : coordPixelXform.getImageWidth() - 1;
        int n8 = n4;
        if (color == null) {
            color = ForeColor;
        }
        graphics2D.setColor(color);
        graphics2D.fillRect(n5, n6, n7 - n5 + 1, n8 - n6 + 1);
        BorderStyle.paintStateBorder(graphics2D, color, n5, n6, bl, n7, n8, bl2);
        return 1;
    }

    private static boolean isPixelIn(CoordPixelXform coordPixelXform, Point point, double d, float f, double d2, float f2) {
        int n = point.y;
        int n2 = coordPixelXform.convertRowToPixel(f);
        if (n < n2) {
            return false;
        }
        int n3 = coordPixelXform.convertRowToPixel(f2);
        if (n > n3) {
            return false;
        }
        int n4 = point.x;
        int n5 = coordPixelXform.convertTimeToPixel(d);
        if (n4 < n5) {
            return false;
        }
        int n6 = coordPixelXform.convertTimeToPixel(d2);
        return n4 <= n6;
    }

    public static void setTimeBoundingBox(TimeAveBox timeAveBox, double d, double d2) {
        CategoryTimeBox[] categoryTimeBoxArray = timeAveBox.arrayOfCategoryTimeBoxes();
        if (SummaryState.isDisplayTypeExclusiveRatio()) {
            Arrays.sort(categoryTimeBoxArray, CategoryTimeBox.EXCL_RATIO_ORDER);
        } else {
            Arrays.sort(categoryTimeBoxArray, CategoryTimeBox.INCL_RATIO_ORDER);
        }
        TimeBoundingBox timeBoundingBox = timeAveBox.getCurrentTimeBoundingBox();
        timeBoundingBox.reinitialize();
        if (SummaryState.isDisplayTypeEqualWeighted()) {
            int n;
            int n2 = 0;
            for (n = categoryTimeBoxArray.length - 1; n >= 0; --n) {
                if (!categoryTimeBoxArray[n].isCategoryVisiblySearchable()) continue;
                ++n2;
            }
            double d3 = d;
            double d4 = (d2 - d) / (double)n2;
            for (n = categoryTimeBoxArray.length - 1; n >= 0; --n) {
                CategoryTimeBox categoryTimeBox = categoryTimeBoxArray[n];
                if (!categoryTimeBox.isCategoryVisiblySearchable()) continue;
                categoryTimeBox.setEarliestTime(d3);
                categoryTimeBox.setLatestFromEarliest(d4);
                d3 = categoryTimeBox.getLatestTime();
                timeBoundingBox.affectTimeBounds(categoryTimeBox);
            }
        } else {
            boolean bl;
            boolean bl2 = bl = !SummaryState.isDisplayTypeExclusiveRatio();
            if (SummaryState.isDisplayTypeCumulative()) {
                double d5 = d;
                double d6 = d2 - d;
                for (int i = categoryTimeBoxArray.length - 1; i >= 0; --i) {
                    CategoryTimeBox categoryTimeBox = categoryTimeBoxArray[i];
                    if (!categoryTimeBox.isCategoryVisiblySearchable()) continue;
                    double d7 = d6 * (double)categoryTimeBox.getCategoryRatio(bl);
                    categoryTimeBox.setEarliestTime(d5);
                    categoryTimeBox.setLatestFromEarliest(d7);
                    d5 = categoryTimeBox.getLatestTime();
                    timeBoundingBox.affectTimeBounds(categoryTimeBox);
                }
            } else {
                double d8 = d2 - d;
                for (int i = categoryTimeBoxArray.length - 1; i >= 0; --i) {
                    CategoryTimeBox categoryTimeBox = categoryTimeBoxArray[i];
                    if (!categoryTimeBox.isCategoryVisiblySearchable()) continue;
                    double d9 = d8 * (double)categoryTimeBox.getCategoryRatio(bl);
                    categoryTimeBox.setEarliestTime(d);
                    categoryTimeBox.setLatestFromEarliest(d9);
                    timeBoundingBox.affectTimeBounds(categoryTimeBox);
                }
            }
        }
    }

    public static int draw(Graphics2D graphics2D, TimeAveBox timeAveBox, CoordPixelXform coordPixelXform, float f, float f2, float f3) {
        float f4;
        float f5;
        if (f < f2) {
            f5 = f;
            f4 = f2;
        } else {
            f5 = f2;
            f4 = f;
        }
        int n = 0;
        TimeBoundingBox timeBoundingBox = timeAveBox.getCurrentTimeBoundingBox();
        CategoryTimeBox[] categoryTimeBoxArray = timeAveBox.arrayOfCategoryTimeBoxes();
        if (SummaryState.isDisplayTypeEqualWeighted() || SummaryState.isDisplayTypeCumulative()) {
            double d;
            double d2;
            if (f5 + f3 < f4 - f3) {
                d2 = timeBoundingBox.getEarliestTime();
                d = timeBoundingBox.getLatestTime();
                n += SummaryState.drawForward(graphics2D, null, coordPixelXform, d2, f5, d, f4);
                f5 += f3;
                f4 -= f3;
            }
            for (int i = categoryTimeBoxArray.length - 1; i >= 0; --i) {
                CategoryTimeBox categoryTimeBox = categoryTimeBoxArray[i];
                Color color = categoryTimeBox.getCategoryColor();
                d2 = categoryTimeBox.getEarliestTime();
                d = categoryTimeBox.getLatestTime();
                n += SummaryState.drawForward(graphics2D, color, coordPixelXform, d2, f5, d, f4);
            }
        } else {
            double d;
            double d3;
            if (f5 + f3 < f4 - f3) {
                d3 = timeBoundingBox.getEarliestTime();
                d = timeBoundingBox.getLatestTime();
                n += SummaryState.drawForward(graphics2D, null, coordPixelXform, d3, f5, d, f4);
                f5 += f3;
                f4 -= f3;
            }
            float f6 = (f4 - f5) / (float)(categoryTimeBoxArray.length * 2);
            for (int i = categoryTimeBoxArray.length - 1; i >= 0; --i) {
                CategoryTimeBox categoryTimeBox = categoryTimeBoxArray[i];
                Color color = categoryTimeBox.getCategoryColor();
                d3 = categoryTimeBox.getEarliestTime();
                d = categoryTimeBox.getLatestTime();
                n += SummaryState.drawForward(graphics2D, color, coordPixelXform, d3, f5, d, f4);
                f5 += f6;
                f4 -= f6;
            }
        }
        return n;
    }

    public static Object containsPixel(TimeAveBox timeAveBox, CoordPixelXform coordPixelXform, Point point, float f, float f2, float f3) {
        float f4;
        float f5;
        if (f < f2) {
            f5 = f;
            f4 = f2;
        } else {
            f5 = f2;
            f4 = f;
        }
        if (point.y < coordPixelXform.convertRowToPixel(f5)) {
            return null;
        }
        if (point.y > coordPixelXform.convertRowToPixel(f4)) {
            return null;
        }
        TimeBoundingBox timeBoundingBox = timeAveBox.getCurrentTimeBoundingBox();
        CategoryTimeBox[] categoryTimeBoxArray = timeAveBox.arrayOfCategoryTimeBoxes();
        if (SummaryState.isDisplayTypeEqualWeighted() || SummaryState.isDisplayTypeCumulative()) {
            double d;
            double d2;
            boolean bl;
            if (f5 + f3 < f4 - f3) {
                f5 += f3;
                f4 -= f3;
                bl = true;
            } else {
                bl = false;
            }
            for (int i = 0; i < categoryTimeBoxArray.length; ++i) {
                CategoryTimeBox categoryTimeBox = categoryTimeBoxArray[i];
                d2 = categoryTimeBox.getEarliestTime();
                if (!SummaryState.isPixelIn(coordPixelXform, point, d2, f5, d = categoryTimeBox.getLatestTime(), f4)) continue;
                return categoryTimeBox;
            }
            if (bl && SummaryState.isPixelIn(coordPixelXform, point, d2 = timeBoundingBox.getEarliestTime(), f5 -= f3, d = timeBoundingBox.getLatestTime(), f4 += f3)) {
                return timeAveBox;
            }
        } else {
            double d;
            double d3;
            boolean bl;
            if (f5 + f3 < f4 - f3) {
                f5 += f3;
                f4 -= f3;
                bl = true;
            } else {
                bl = false;
            }
            float f6 = (f4 - f5) / (float)(categoryTimeBoxArray.length * 2);
            f5 += f6 * (float)(categoryTimeBoxArray.length - 1);
            f4 -= f6 * (float)(categoryTimeBoxArray.length - 1);
            for (int i = 0; i < categoryTimeBoxArray.length; ++i) {
                CategoryTimeBox categoryTimeBox = categoryTimeBoxArray[i];
                d3 = categoryTimeBox.getEarliestTime();
                if (SummaryState.isPixelIn(coordPixelXform, point, d3, f5, d = categoryTimeBox.getLatestTime(), f4)) {
                    return categoryTimeBox;
                }
                f5 -= f6;
                f4 += f6;
            }
            if (bl) {
                f5 += f6;
                f4 -= f6;
                d3 = timeBoundingBox.getEarliestTime();
                if (SummaryState.isPixelIn(coordPixelXform, point, d3, f5 -= f3, d = timeBoundingBox.getLatestTime(), f4 += f3)) {
                    return timeAveBox;
                }
            }
        }
        return null;
    }
}

