/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.rtf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import javax.swing.text.rtf.AbstractFilter;

abstract class RTFParser
extends AbstractFilter {
    public int level = 0;
    private int state = 0;
    private StringBuffer currentCharacters = new StringBuffer();
    private String pendingKeyword = null;
    private int pendingCharacter;
    private long binaryBytesLeft;
    ByteArrayOutputStream binaryBuf;
    private boolean[] savedSpecials;
    protected PrintStream warnings;
    private final int S_text = 0;
    private final int S_backslashed = 1;
    private final int S_token = 2;
    private final int S_parameter = 3;
    private final int S_aftertick = 4;
    private final int S_aftertickc = 5;
    private final int S_inblob = 6;
    static final boolean[] rtfSpecialsTable = (boolean[])AbstractFilter.noSpecialsTable.clone();

    static {
        RTFParser.rtfSpecialsTable[10] = true;
        RTFParser.rtfSpecialsTable[13] = true;
        RTFParser.rtfSpecialsTable[123] = true;
        RTFParser.rtfSpecialsTable[125] = true;
        RTFParser.rtfSpecialsTable[92] = true;
    }

    public RTFParser() {
        this.specialsTable = rtfSpecialsTable;
    }

    public abstract void begingroup();

    public void close() throws IOException {
        this.flush();
        if (this.state != 0 || this.level > 0) {
            this.warning("Truncated RTF file.");
            while (this.level > 0) {
                this.endgroup();
                --this.level;
            }
        }
        super.close();
    }

    public abstract void endgroup();

    public void flush() throws IOException {
        super.flush();
        if (this.state == 0 && this.currentCharacters.length() > 0) {
            this.handleText(this.currentCharacters.toString());
            this.currentCharacters = new StringBuffer();
        }
    }

    public abstract void handleBinaryBlob(byte[] var1);

    public abstract boolean handleKeyword(String var1);

    public abstract boolean handleKeyword(String var1, int var2);

    public void handleText(char c) {
        this.handleText(String.valueOf(c));
    }

    public abstract void handleText(String var1);

    protected void warning(String string) {
        if (this.warnings != null) {
            this.warnings.println(string);
        }
    }

    public void write(char c) throws IOException {
        switch (this.state) {
            case 0: {
                if (c == '\n' || c == '\r') break;
                if (c == '{') {
                    if (this.currentCharacters.length() > 0) {
                        this.handleText(this.currentCharacters.toString());
                        this.currentCharacters = new StringBuffer();
                    }
                    ++this.level;
                    this.begingroup();
                    break;
                }
                if (c == '}') {
                    if (this.currentCharacters.length() > 0) {
                        this.handleText(this.currentCharacters.toString());
                        this.currentCharacters = new StringBuffer();
                    }
                    if (this.level == 0) {
                        throw new IOException("Too many close-groups in RTF text");
                    }
                    this.endgroup();
                    --this.level;
                    break;
                }
                if (c == '\\') {
                    if (this.currentCharacters.length() > 0) {
                        this.handleText(this.currentCharacters.toString());
                        this.currentCharacters = new StringBuffer();
                    }
                    this.state = 1;
                    break;
                }
                this.currentCharacters.append(c);
                break;
            }
            case 1: {
                if (c == '\'') {
                    this.state = 4;
                    break;
                }
                if (!Character.isLetter(c)) {
                    char[] cArray = new char[]{c};
                    if (!this.handleKeyword(new String(cArray))) {
                        this.warning("Unknown keyword: " + cArray + " (" + (byte)c + ")");
                    }
                    this.state = 0;
                    this.pendingKeyword = null;
                    break;
                }
                this.state = 2;
            }
            case 2: {
                if (Character.isLetter(c)) {
                    this.currentCharacters.append(c);
                    break;
                }
                this.pendingKeyword = this.currentCharacters.toString();
                this.currentCharacters = new StringBuffer();
                if (Character.isDigit(c) || c == '-') {
                    this.state = 3;
                    this.currentCharacters.append(c);
                    break;
                }
                boolean bl = this.handleKeyword(this.pendingKeyword);
                if (!bl) {
                    this.warning("Unknown keyword: " + this.pendingKeyword);
                }
                this.pendingKeyword = null;
                this.state = 0;
                if (Character.isWhitespace(c)) break;
                this.write(c);
                break;
            }
            case 3: {
                if (Character.isDigit(c)) {
                    this.currentCharacters.append(c);
                    break;
                }
                if (this.pendingKeyword.equals("bin")) {
                    long l = Long.parseLong(this.currentCharacters.toString());
                    this.pendingKeyword = null;
                    this.state = 6;
                    this.binaryBytesLeft = l;
                    this.binaryBuf = this.binaryBytesLeft > Integer.MAX_VALUE ? new ByteArrayOutputStream(Integer.MAX_VALUE) : new ByteArrayOutputStream((int)this.binaryBytesLeft);
                    this.savedSpecials = this.specialsTable;
                    this.specialsTable = AbstractFilter.allSpecialsTable;
                    break;
                }
                int n = Integer.parseInt(this.currentCharacters.toString());
                boolean bl = this.handleKeyword(this.pendingKeyword, n);
                if (!bl) {
                    this.warning("Unknown keyword: " + this.pendingKeyword + " (param " + this.currentCharacters + ")");
                }
                this.pendingKeyword = null;
                this.currentCharacters = new StringBuffer();
                this.state = 0;
                if (Character.isWhitespace(c)) break;
                this.write(c);
                break;
            }
            case 4: {
                if (Character.digit(c, 16) == -1) {
                    this.state = 0;
                    break;
                }
                this.pendingCharacter = Character.digit(c, 16);
                this.state = 5;
                break;
            }
            case 5: {
                this.state = 0;
                if (Character.digit(c, 16) == -1) break;
                this.pendingCharacter = this.pendingCharacter * 16 + Character.digit(c, 16);
                c = this.translationTable[this.pendingCharacter];
                if (c == '\u0000') break;
                this.handleText(c);
                break;
            }
            case 6: {
                this.binaryBuf.write(c);
                --this.binaryBytesLeft;
                if (this.binaryBytesLeft != 0L) break;
                this.state = 0;
                this.specialsTable = this.savedSpecials;
                this.savedSpecials = null;
                this.handleBinaryBlob(this.binaryBuf.toByteArray());
                this.binaryBuf = null;
            }
        }
    }

    public void write(String string) throws IOException {
        if (this.state != 0) {
            int n = 0;
            int n2 = string.length();
            while (n < n2 && this.state != 0) {
                this.write(string.charAt(n));
                ++n;
            }
            if (n >= n2) {
                return;
            }
            string = string.substring(n);
        }
        if (this.currentCharacters.length() > 0) {
            this.currentCharacters.append(string);
        } else {
            this.handleText(string);
        }
    }

    public void writeSpecial(int n) throws IOException {
        this.write((char)n);
    }
}

