/*

    mpv_gtk.c

    GTK (X Window) Interface (Linux/Unix)

    mp - Programmer Text Editor

    Copyright (C) 1991/2001 Angel Ortega <angel@triptico.com>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

    http://www.triptico.com

*/

/*

    WARNING:

    This interface is far from complete. It does not work. Anything can happen.

*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <gtk/gtk.h>

#include "mp_core.h"
#include "mp_video.h"
#include "mp_iface.h"
#include "mp_synhi.h"


GtkWidget * window=NULL;
GtkWidget * box=NULL;
GtkWidget * menu=NULL;
GtkWidget * menu_bar=NULL;

static char _mpv_title_buffer[1024];
static char _mpv_status_line_buffer[1024];


/*******************
	Code
*******************/

/**
 * mpv_strcasecmp - Case ignoring string compare
 * @s1: first string
 * @s2: second string
 *
 * Case ignoring string compare. System dependent
 * (strcasecmp in Unix, stricmp in Win32)
 */
int mpv_strcasecmp(char * s1, char * s2)
{
	return(strcasecmp(s1,s2));
}


void mpv_goto(int x, int y)
{
}


void mpv_char(int c, int color)
{
}


void mpv_str(char * str, int color)
{
}


void mpv_cursor(int x, int y)
{
}


void mpv_refresh(void)
{
}


static void _mpv_title_status(void)
{
	char tmp[2048];

	strncpy(tmp,"mp " VERSION, sizeof(tmp));

	if(_mpv_title_buffer[0]!='\0')
	{
		strcat(tmp," - ");
		strcat(tmp,_mpv_title_buffer);
	}

	if(_mpv_status_line_buffer[0]!='\0')
		strcat(tmp,_mpv_status_line_buffer);

	gtk_window_set_title(GTK_WINDOW(window), tmp);
}


void mpv_title(char * str)
{
	if(str)
		strncpy(_mpv_title_buffer,str,sizeof(_mpv_title_buffer));
	else
		_mpv_title_buffer[0]='\0';

	_mpv_title_status();
}


void mpv_status_line(char * str)
{
	if(str)
		strncpy(_mpv_status_line_buffer,str,sizeof(_mpv_status_line_buffer));
	else
		_mpv_status_line_buffer[0]='\0';

	_mpv_title_status();
}


static char * _mpv_filter_menu_label(char * label)
{
	static char tmp[1024];
	int n;

	for(n=0;*label && *label!='\t';label++)
	{
		if(*label!='&')
			tmp[n++]=*label;
	}
	tmp[n]='\0';

	return(tmp);
}


void mpv_add_menu(char * label)
/* adds a menu */
{
	GtkWidget * menu_item;

	if(menu_bar==NULL)
		menu_bar=gtk_menu_bar_new();

	menu=gtk_menu_new();

	label=_mpv_filter_menu_label(label);
	menu_item=gtk_menu_item_new_with_label(label);

	gtk_widget_show(menu_item);

	gtk_menu_item_set_submenu(GTK_MENU_ITEM(menu_item), menu);

	gtk_menu_bar_append(GTK_MENU_BAR(menu_bar), menu_item);
}


static void _mpv_menu_item(int key)
/* menu click callback */
{
	mpi_action(_mp_active, key);

	if(_mpi_exit_requested)
		gtk_main_quit();
}


void mpv_add_menu_item(char * label, int key, int * toggle)
/* adds a menu item */
{
	GtkWidget * menu_item;

	label=_mpv_filter_menu_label(label);

	if(*label=='-')
		menu_item=gtk_menu_item_new();
	else
		menu_item=gtk_menu_item_new_with_label(label);

	gtk_menu_append(GTK_MENU(menu), menu_item);

	gtk_signal_connect_object(GTK_OBJECT(menu_item), "activate",
		GTK_SIGNAL_FUNC(_mpv_menu_item), (gpointer) key);

	gtk_widget_show(menu_item);
}


int mpv_menu(void)
{
	return(0);
}


void mpv_alert(char * msg, char * msg2)
{
}


int mpv_confirm(char * prompt)
{
	return(0);
}


char * mpv_readline(int type, char * prompt, char * def)
{
	return(NULL);
}


int mpv_list(char * title, mp_txt * txt)
{
	return(0);
}


int mpv_help(char * term, int synhi)
{
	return(0);
}


int mpv_zoom(int inc)
{
	return(0);
}


void mpv_scrollbar(int pos, int size, int max)
{
}


int mpv_insert_template(void)
{
	return(0);
}


int mpv_startup(void)
{
	window=gtk_window_new(GTK_WINDOW_TOPLEVEL);

	gtk_signal_connect(GTK_OBJECT(window), "delete_event",
		(GtkSignalFunc) gtk_main_quit, NULL);

	box=gtk_vbox_new(FALSE, 2);
	gtk_container_add(GTK_CONTAINER(window), box);
	gtk_box_pack_start(GTK_BOX(box),menu_bar,FALSE,FALSE,2);

	gtk_widget_show(menu_bar);
	gtk_widget_show(box);
	gtk_widget_show(window);

	return(0);
}


void mpv_shutdown(void)
{
}


int main(int argc, char * argv[])
/* main */
{
	gtk_init(&argc,&argv);

	mp_startup();
	mps_startup();
	mpi_startup();
	mpv_startup();

	/* create empty text if no file is open */
	if(_mp_active==NULL)
	{
		mp_create_txt(MSG_UNNAMED);
		mps_auto_synhi(_mp_active);
	}

	/* build _mpi_template_file */
	{
		char * home=getenv("HOME");

		if(home!=NULL)
			sprintf(_mpi_template_file,"%s/.mp_templates",home);
		else
			strncpy(_mpi_template_file,".mp_templates",sizeof(_mpi_template_file));
	}

	mpv_title(_mp_active->name);
	mpi_draw_all(_mp_active);

	/* main loop */
	gtk_main();

	mpv_shutdown();
	mp_shutdown();

	return(0);
}
