/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.record;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.record.Buffer;
import org.apache.hadoop.record.Index;
import org.apache.hadoop.record.RecordInput;
import org.apache.hadoop.record.Utils;

public class BinaryRecordInput
implements RecordInput {
    private DataInput in;
    private static ThreadLocal bIn = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return new BinaryRecordInput();
        }
    };

    private BinaryRecordInput() {
    }

    private void setDataInput(DataInput inp) {
        this.in = inp;
    }

    public static BinaryRecordInput get(DataInput inp) {
        BinaryRecordInput bin = (BinaryRecordInput)bIn.get();
        bin.setDataInput(inp);
        return bin;
    }

    public BinaryRecordInput(InputStream strm) {
        this.in = new DataInputStream(strm);
    }

    public BinaryRecordInput(DataInput din) {
        this.in = din;
    }

    @Override
    public byte readByte(String tag) throws IOException {
        return this.in.readByte();
    }

    @Override
    public boolean readBool(String tag) throws IOException {
        return this.in.readBoolean();
    }

    @Override
    public int readInt(String tag) throws IOException {
        return Utils.readVInt(this.in);
    }

    @Override
    public long readLong(String tag) throws IOException {
        return Utils.readVLong(this.in);
    }

    @Override
    public float readFloat(String tag) throws IOException {
        return this.in.readFloat();
    }

    @Override
    public double readDouble(String tag) throws IOException {
        return this.in.readDouble();
    }

    @Override
    public String readString(String tag) throws IOException {
        return Utils.fromBinaryString(this.in);
    }

    @Override
    public Buffer readBuffer(String tag) throws IOException {
        int len = Utils.readVInt(this.in);
        byte[] barr = new byte[len];
        this.in.readFully(barr);
        return new Buffer(barr);
    }

    @Override
    public void startRecord(String tag) throws IOException {
    }

    @Override
    public void endRecord(String tag) throws IOException {
    }

    @Override
    public Index startVector(String tag) throws IOException {
        return new BinaryIndex(this.readInt(tag));
    }

    @Override
    public void endVector(String tag) throws IOException {
    }

    @Override
    public Index startMap(String tag) throws IOException {
        return new BinaryIndex(this.readInt(tag));
    }

    @Override
    public void endMap(String tag) throws IOException {
    }

    private static class BinaryIndex
    implements Index {
        private int nelems;

        private BinaryIndex(int nelems) {
            this.nelems = nelems;
        }

        @Override
        public boolean done() {
            return this.nelems <= 0;
        }

        @Override
        public void incr() {
            --this.nelems;
        }
    }
}

