/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.file.tfile;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.fs.FSDataInputStream;

class BoundedRangeFileInputStream
extends InputStream {
    private FSDataInputStream in;
    private long pos;
    private long end;
    private long mark;
    private final byte[] oneByte = new byte[1];

    public BoundedRangeFileInputStream(FSDataInputStream in, long offset, long length) {
        if (offset < 0L || length < 0L) {
            throw new IndexOutOfBoundsException("Invalid offset/length: " + offset + "/" + length);
        }
        this.in = in;
        this.pos = offset;
        this.end = offset + length;
        this.mark = -1L;
    }

    @Override
    public int available() throws IOException {
        int avail = this.in.available();
        if (this.pos + (long)avail > this.end) {
            avail = (int)(this.end - this.pos);
        }
        return avail;
    }

    @Override
    public int read() throws IOException {
        int ret = this.read(this.oneByte);
        if (ret == 1) {
            return this.oneByte[0] & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if ((off | len | off + len | b.length - (off + len)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        int n = (int)Math.min(Integer.MAX_VALUE, Math.min((long)len, this.end - this.pos));
        if (n == 0) {
            return -1;
        }
        int ret = 0;
        FSDataInputStream fSDataInputStream = this.in;
        synchronized (fSDataInputStream) {
            this.in.seek(this.pos);
            ret = this.in.read(b, off, n);
        }
        if (ret < 0) {
            this.end = this.pos;
            return -1;
        }
        this.pos += (long)ret;
        return ret;
    }

    @Override
    public long skip(long n) throws IOException {
        long len = Math.min(n, this.end - this.pos);
        this.pos += len;
        return len;
    }

    @Override
    public void mark(int readlimit) {
        this.mark = this.pos;
    }

    @Override
    public void reset() throws IOException {
        if (this.mark < 0L) {
            throw new IOException("Resetting to invalid mark");
        }
        this.pos = this.mark;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void close() {
        this.in = null;
        this.pos = this.end;
        this.mark = -1L;
    }
}

