/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.modlogan.org
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: generate.c,v 1.9 2002/10/23 15:05:35 le_zas Exp $
*/

#include <libintl.h>
#include <locale.h>
#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <math.h>

#include "mconfig.h"
#include "misc.h"
#include "mstate.h"
#include "mlocale.h"
#include "mhash.h"
#include "mlist.h"
#include "mdatatypes.h"

#define HIGHLIGHT	1
#define GROUPING	2

#if 0

int show_mlist (FILE *f, mlist *l, int count, int opt) {
	int i = 0;

	if (!l) return 0;
	l = mlist_sort_limited(l, count);

	if (!l) return -1;

	while (l && (i++ < count)) {
		data_StrInt *data = (data_StrInt *)l->data;

		if (data) {
			fprintf(f,"<TR><TD width=\"15%%\" align=right>%i</TD><TD>", data->count);
			if (opt) {
				fprintf(f,"<a href=\"%s\">%s</a>", data->string, html_encode(data->string));
			} else {
				fprintf(f,"%s", html_encode(data->string));
			}
			fprintf(f,"</TD></TR>\n");
		}

		l = l->next;
	}

	return 0;
}

int show_mhash (FILE *f, mhash *h[], int count, int opt) {
	mlist *l, *first;
	int i = 0;

	if (!h) return 0;

	first = l = mlist_init();

	mhash_unfold_sorted_limited(h, l, count);

	while (l && (i++ < count)) {
		data_StrInt *data = (data_StrInt *)l->data;

		if (data) {
			if ((opt & GROUPING) && data->type == M_GROUP) {
				fprintf(f,"<TR><TD width=\"15%%\" align=right>%i</TD><TD bgcolor=\"#eeffff\">", data->count);
				fprintf(f,"%s", html_encode(data->string));
			} else {
				fprintf(f,"<TR><TD width=\"15%%\" align=right>%i</TD><TD>", data->count);
				if (opt & HIGHLIGHT) {
					fprintf(f,"<a href=\"%s\">%s</a>", data->string, html_encode(data->string));
				} else {
					fprintf(f,"%s", html_encode(data->string));
				}
			}
			fprintf(f,"</TD></TR>\n");
		}

		l = l->next;
	}

	mlist_free(first);

	return 0;
}

int mhash_status_unfold_sorted_limited(mhash *h[], mlist *l, int count ) {
	int i, j;
	data_StrInt *data, *ins_data;
	char __dummy__[] = "999";
	char __dummy_2_[] = "";
	char *max, *last = __dummy_2_;

	for ( j = 0; j < count; j++) {
		data = NULL;

		max = __dummy__;

		for ( i = 0; i < HASH_SIZE; i++) {
			if (h[i]->list) {
				mlist *hl;

				hl = h[i]->list;
				while (hl) {
					if (hl->data) {
						if ( strcmp(((data_StrInt *)hl->data)->string, max) < 0 &&
							strcmp(((data_StrInt *)hl->data)->string, last) > 0) {
							max = ((data_StrInt *)hl->data)->string;
							data = (data_StrInt *)hl->data;
						}
					}
					hl = hl->next;
				}
			}
		}

		if (data) {
			ins_data = createStrInt(data->string, data->count);

			mlist_insert(l, ins_data);

			last = data->string;
		}
	}

	return 0;
}

int show_status_mhash (FILE *f, mhash *h[], int count) {
	mlist *l, *first;
	int i = 0;

	if (!h) return 0;

	first = l = mlist_init();

	mhash_status_unfold_sorted_limited(h, l, count);

	while (l && (i++ < count)) {
		data_StrInt *data = (data_StrInt *)l->data;

		if (data)
			fprintf(f,"<TR><TD width=\"15%%\" align=right>%i</TD><TD>%s - %s</TD></TR>\n", data->count, data->string, mhttpcodes(strtol(data->string, NULL, 10)));

		l = l->next;
	}

	mlist_free(first);

	return 0;
}
#endif

int mplugins_output_generate_monthly_output(mconfig *conf, mstate *state, const char *subpath) {
#if 0
	unsigned int i;
	unsigned int min, sec;
	double d = 0;
	FILE *f;
	char filename[255];
	char *ref;
	data_History sumdat, maxdat;
	int last_day = 1;

	sprintf(filename, "%s/m_usage_%04i%02i.csv",
		conf->outputdir ? conf->outputdir : ".",
		state->year, state->month);

	if (!(f = fopen(filename, "w"))) {
		return -1;
	}

	table_start(f, _("Daily Statistics"), 6);
	fprintf(f,"<TR><TH>%s</TH><TH bgcolor=\"%s\">%s</TH><TH bgcolor=\"%s\">%s</TH><TH bgcolor=\"%s\">%s</TH><TH bgcolor=\"%s\">%s</TH><TH bgcolor=\"%s\">%s</TH></TR>\n",
		_("Day"),
		conf->col_hits,
		_("Hits"),
		conf->col_files,
		_("Files"),
		conf->col_pages,
		_("Pages"),
		conf->col_visits,
		_("Visits"),
		conf->col_xfer,
		_("KBytes")
		);
	for ( i = 0; i < last_day; i++) {
		fprintf(f,"<TR><TD>%i</TD><TD align=right>%li</TD><TD align=right>%li</TD><TD align=right>%li</TD><TD align=right>%li</TD><TD align=right>%.0f</TD></TR>\n",
			i+1,
			state->days[i].hits,
			state->days[i].files,
			state->days[i].pages,
			state->days[i].visits,
			state->days[i].xfersize / 1024
			);
	}

	ref = create_pic_24_hour(conf, state);

	if (ref && strlen(ref)) {
		fprintf(f, "%s", ref);
	}

	table_start(f, _("Hourly Statistics"), 6);
	fprintf(f,"<TR><TH>%s</TH><TH bgcolor=\"%s\">%s</TH><TH bgcolor=\"%s\">%s</TH><TH bgcolor=\"%s\">%s</TH><TH bgcolor=\"%s\">%s</TH><TH bgcolor=\"%s\">%s</TH></TR>\n",
		_("Hour"),
		conf->col_hits,
		_("Hits"),
		conf->col_files,
		_("Files"),
		conf->col_pages,
		_("Pages"),
		conf->col_visits,
		_("Visits"),
		conf->col_xfer,
		_("KBytes")
		);
	for ( i = 0; i < 24; i++) {
		fprintf(f,"<TR><TD>%i</TD><TD align=right>%li</TD><TD align=right>%li</TD><TD align=right>%li</TD><TD align=right>%li</TD><TD align=right>%.0f</TD></TR>\n",
			i,
			state->hours[i].hits,
			state->hours[i].files,
			state->hours[i].pages,
			state->hours[i].visits,
			state->hours[i].xfersize / 1024
			);
	}

	table_start(f, _("Requested URL's"), 2);
	fprintf(f,"<TR><TH bgcolor=\"%s\">%s</TH><TH>%s</TH></TR>\n",
		conf->col_hits,
		_("Hits"),
		_("URL")
		);
	show_mhash(f,state->req_url_hash,10,HIGHLIGHT);

	table_start(f, _("Used Operating Systems"), 2);
	fprintf(f,"<TR><TH bgcolor=\"%s\">%s</TH><TH>%s</TH></TR>\n",
		conf->col_hits,
		_("Hits"),
		_("Operating System")
		);
	show_mhash(f,state->os_hash,10,0);

	table_start(f, _("Hosts"), 2);
	fprintf(f,"<TR><TH bgcolor=\"%s\">%s</TH><TH>%s</TH></TR>\n",
		conf->col_hits,
		_("Hits"),
		_("Host")
		);
	show_mhash(f,state->host_hash,10,0);

	table_start(f, _("Referring URL's"), 2);
	fprintf(f,"<TR><TH bgcolor=\"%s\">%s</TH><TH>%s</TH></TR>\n",
		conf->col_hits,
		_("Hits"),
		_("Referrer")
		);
	show_mhash(f,state->ref_url_hash,30, HIGHLIGHT | GROUPING);

	table_start(f, _("Entry Pages"), 2);
	fprintf(f,"<TR><TH bgcolor=\"%s\">%s</TH><TH>%s</TH></TR>\n",
		conf->col_hits,
		_("Hits"),
		_("Entry Page")
		);
	show_mlist(f,state->entry_pages,10,HIGHLIGHT);

	table_start(f, _("Exit Pages"), 2);
	fprintf(f,"<TR><TH bgcolor=\"%s\">%s</TH><TH>%s</TH></TR>\n",
		conf->col_hits,
		_("Hits"),
		_("Exit Page")
		);
	show_mlist(f,state->exit_pages,10,HIGHLIGHT);

	table_start(f, _("Indexed Pages"), 2);
	fprintf(f,"<TR><TH bgcolor=\"%s\">%s</TH><TH>%s</TH></TR>\n",
		conf->col_hits,
		_("Hits"),
		_("Indexed Page")
		);
	show_mlist(f,state->indexed_pages,10,HIGHLIGHT);

	table_start(f, _("Used Browsers"), 2);
	fprintf(f,"<TR><TH bgcolor=\"%s\">%s</TH><TH>%s</TH></TR>\n",
		conf->col_hits,
		_("Hits"),
		_("Browser")
		);
	show_mhash(f,state->ua_hash,10,0);

	table_start(f, _("Used Request Protocol"), 2);
	fprintf(f,"<TR><TH bgcolor=\"%s\">%s</TH><TH>%s</TH></TR>\n",
		conf->col_hits,
		_("Hits"),
		_("Protocol")
		);
	show_mhash(f,state->req_prot_hash,10,0);

	table_start(f, _("Used Request Method"), 2);
	fprintf(f,"<TR><TH bgcolor=\"%s\">%s</TH><TH>%s</TH></TR>\n",
		conf->col_hits,
		_("Hits"),
		_("Method")
		);
	show_mhash(f,state->req_meth_hash,10,0);

	table_start(f, _("Status Code"), 2);
	fprintf(f,"<TR><TH bgcolor=\"%s\">%s</TH><TH>%s</TH></TR>\n",
		conf->col_hits,
		_("Hits"),
		_("Status Code")
		);
	show_status_mhash(f,state->status_hash,10);

	table_start(f, _("Robots"), 2);
	fprintf(f,"<TR><TH bgcolor=\"%s\">%s</TH><TH>%s</TH></TR>\n",
		conf->col_hits,
		_("Hits"),
		_("Robot")
		);
	show_mhash(f,state->robots,10,0);

	table_start(f, _("Bookmarked Pages"), 2);
	fprintf(f,"<TR><TH bgcolor=\"%s\">%s</TH><TH>%s</TH></TR>\n",
		conf->col_hits,
		_("Hits"),
		_("Bookmarked Page")
		);
	show_mhash(f,state->bookmarks,10,HIGHLIGHT);

	table_start(f, _("Missing File / Broken Link"), 2);
	fprintf(f,"<TR><TH bgcolor=\"%s\">%s</TH><TH>%s</TH></TR>\n",
		conf->col_hits,
		_("Hits"),
		_("Broken Link")
		);
	show_mhash(f,state->status_missing_file,10,HIGHLIGHT);

	table_start(f, _("Internal Errors"), 2);
	show_mhash(f,state->status_internal_error,10,0);

	table_start(f, _("SearchStrings"), 2);
	fprintf(f,"<TR><TH bgcolor=\"%s\">%s</TH><TH>%s</TH></TR>\n",
		conf->col_hits,
		_("Hits"),
		_("Search String")
		);
	show_mhash(f,state->searchstring,10,0);

	table_start(f, _("SearchEngines"), 2);
	fprintf(f,"<TR><TH bgcolor=\"%s\">%s</TH><TH>%s</TH></TR>\n",
		conf->col_hits,
		_("Hits"),
		_("Search Engine")
		);
	show_mhash(f,state->searchsite,10,HIGHLIGHT);

	fclose(f);

	free(q);
	q = NULL;
	q_len = 0;
#endif
	return 0;
}

int mplugins_output_generate_history_output(mconfig *conf, mlist *history, const char *subpath) {
	return 0;
}
