/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.kneschke.de/projekte/modlogan
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: datatype.c,v 1.5 2001/10/06 16:32:17 ostborn Exp $
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>

#include <zlib.h>

#include "config.h"
#include "mdatatypes.h"
#include "datatype.h"

/* begin of State */

int mdata_State_to_xml(gzFile *fd, mdata *data) {
	return 0;
}

int mdata_State_free(mdata *data) {
	if (!data) return -1;
	if (data->type != M_DATA_TYPE_STATE) return -1;
	
	if (data->data.state.state) mstate_free(data->data.state.state);
	if (data->data.state.history) mlist_free(data->data.state.history);
	
	return 0;
}

int mdata_State_setdata(mdata *data, const char *str, mstate *state, mlist *hist) {
	
	data->key	= malloc(strlen(str)+1);
	assert(data->key);
	strcpy(data->key, str);
	
	data->data.state.state		= state ? state : mstate_init();
	data->data.state.history	= hist ? hist : mlist_init();
	
	return 0;
}

int mdata_State_from_xml(mstate_stack *m, int tagtype, mdata *data, int type, const xmlChar *value, const xmlChar **attrs) {
	return 0;
}


int mdata_State_append(mdata *dst, mdata *src) {
	
	/* combining state */
	
	fprintf(stderr, "%s.%d: (state) abstract function 'append' !!\n", __FILE__, __LINE__);
	
	return 0;
}

mdata *mdata_State_init() {
	mdata *data = mdata_init();
	assert(data);
	
	data->key		= NULL;
	data->type		= M_DATA_TYPE_STATE;
	
#ifdef DEBUG_DATATYPES
	fprintf(stderr, "%s.%d: got %ld (%d)\n", __FILE__, __LINE__, data->id, data->type);
#endif
/* init specifics */	
	data->data.state.state		= NULL;
	data->data.state.history	= NULL;
	
	return data;
}

mdata *mdata_State_copy(mdata *src) {
	mdata *data = mdata_State_init();
	assert(data);
	
	fprintf(stderr, "%s.%d: (state) abstract function 'copy' !!\n", __FILE__, __LINE__);
	
	mdata_State_setdata(data, src->key, src->data.state.state, src->data.state.history);
	
	return data;
}

mdata *mdata_State_create(const char *str, mstate *state, mlist *hist) {
	mdata *data = mdata_State_init();
	assert(data);
	mdata_State_setdata(data, str, state, hist);
	
	return data;
}

/* end of State */
