///////////////////////////////////////////////////////////////////////////////
// $Id: maptoolselect.h,v 1.1 2004/04/04 16:41:49 krake Exp $
//
// Package:   MOAGG Edit - Level Editor for MOAGG
// Copyright: Kevin Krammer, 2003
//
///////////////////////////////////////////////////////////////////////////////
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.
//
///////////////////////////////////////////////////////////////////////////////

/*! \file    maptoolselect.h
    \author  Kevin Krammer, kevin.krammer@gmx.at
    \brief   Declaration of the selection tool class for maps
*/

#ifndef MAPTOOLSELECT_H
#define MAPTOOLSELECT_H

// Qt includes
#include <qrect.h>

// local includes
#include "maptool.h"

class MapToolSelect : public MapTool
{
public:
	MapToolSelect(MapDocument* doc);

	~MapToolSelect();

	void activate();

	bool usedMousePress(uint row, uint col, int button);
	bool usedMouseRelease(uint row, uint col, int button);
	bool usedMouseMove(uint row, uint col, int buttons);

	bool coversTileAt(uint row, uint col) const;

	QRect coverArea() const;

private:
	QRect  m_rect;
	QPoint m_start;
	QPoint m_end;
};

#endif

// End of file
