///////////////////////////////////////////////////////////////////////////////
// $Id: maptoolpoint.cpp,v 1.3 2004/10/03 19:30:45 krake Exp $
//
// Package:   MOAGG Edit - Level Editor for MOAGG
// Copyright: Kevin Krammer, 2003
//
///////////////////////////////////////////////////////////////////////////////
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.
//
///////////////////////////////////////////////////////////////////////////////

/*! \file    maptoolpoint.cpp
    \author  Kevin Krammer, kevin.krammer@gmx.at
    \brief   Implementation of the point tool class for maps
*/

// Qt includes
#include <qrect.h>

// local includes
#include "mapdocument.h"
#include "maptoolpoint.h"

///////////////////////////////////////////////////////////////////////////////

MapToolPoint::MapToolPoint(MapDocument* doc) : MapTool(doc)
{
}

///////////////////////////////////////////////////////////////////////////////

MapToolPoint::~MapToolPoint()
{
}

///////////////////////////////////////////////////////////////////////////////

void MapToolPoint::activate()
{
	m_lastPoint = QPoint(-1, -1);
}

///////////////////////////////////////////////////////////////////////////////

bool MapToolPoint::usedMousePress(uint row, uint col, int button)
{
	if (button != Qt::LeftButton) return false;

	// sanity checks
	if (m_doc == 0) return false;
	if (static_cast<int>(row) >= m_doc->numRows() ||
	    static_cast<int>(col) >= m_doc->numCols()) return false;

	// Do not draw on invisible layers
	if (!m_doc->isLayerVisible(m_doc->currentLayer())) return false;
	
	m_lastPoint = QPoint(col, row);

	m_doc->drawCurrentTileAt(row, col);

	return true;
}

///////////////////////////////////////////////////////////////////////////////

bool MapToolPoint::usedMouseMove(uint row, uint col, int button)
{
	// sanity checks
	if (m_doc == 0) return false;
	if (static_cast<int>(row) >= m_doc->numRows() ||
	    static_cast<int>(col) >= m_doc->numCols()) return false;

	// Do not draw on invisible layers
	if (!m_doc->isLayerVisible(m_doc->currentLayer())) return false;
	
	m_lastPoint = QPoint(col, row);
	if ((button & Qt::LeftButton) != 0)
		m_doc->drawCurrentTileAt(row, col);

	return true;
}

///////////////////////////////////////////////////////////////////////////////

bool MapToolPoint::coversTileAt(uint row, uint col) const
{
	return m_lastPoint == QPoint(col, row);
}

///////////////////////////////////////////////////////////////////////////////

QRect MapToolPoint::coverArea() const
{
	return QRect(m_lastPoint.x(), m_lastPoint.y(), 1, 1);
}

// End of file
