///////////////////////////////////////////////////////////////////////////////
// $Id: mapdocument.h,v 1.8 2004/09/29 20:08:08 krake Exp $
//
// Package:   MOAGG Edit - Level Editor for MOAGG
// Copyright: Kevin Krammer, 2003
//
///////////////////////////////////////////////////////////////////////////////
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.
//
///////////////////////////////////////////////////////////////////////////////

/*! \file    mapdocument.h
    \author  Kevin Krammer, kevin.krammer@gmx.at
    \brief   Declaration of the map document class
*/

#ifndef MAPDOCUMENT_H
#define MAPDOCUMENT_H

// Qt includes
#include <qptrlist.h>
#include <qrect.h>
#include <qstring.h>

// local includes
#include "document.h"

// forward declarations
class MapLayer;
class QPixmap;
class QPoint;
class TileSet;

class MapDocument : public Document
{
public:
	MapDocument();
	~MapDocument();

	bool init(const QString& tilesetfile);

	bool init(const TileSet& tileset);

	bool init(int rows, int cols, const QString& tilesetfile);

	bool openFile(const QString& filename);

	bool saveFile();

	bool saveFileAs(const QString& filename);

	QString fileName() const { return m_fileName; }

	QString fileFilter() const { return "MOAGG mapfile (*.map)"; }

	bool isModified() const { return m_modified; }

	bool readFromDevice(QIODevice* device);
	bool writeToDevice(QIODevice* device) const;

	void setCurrentLayer(uint index);

	uint currentLayer() const { return m_currentLayerIndex; }

	uint layerCount() const { return m_layers.count(); }

	int groupForLayer(uint index) const;

	void insertLayer(uint groupindex, int layerindex = -1);

	void removeLayer(uint layerindex);

	void moveLayer(uint fromindex, uint toindex);

	bool isLayerVisible(uint layerindex) const;

	void setLayerVisible(uint layerindex, bool on);

	bool isLayerBackground(uint layerindex) const;

	void setLayerBackground(uint layerindex, bool on);

	void setLayerImageParameters(int alpha, int brightness);

	void getLayerImageParameters(int& alpha, int& brightness) const;

	void setCurrentTile(uint tileindex);

	void drawCurrentTileAt(int row, int col);

	QPixmap* pixmap(int row, int col);

	void resize(int rows, int cols);

	int numRows() const { return m_rows; }
	int numCols() const { return m_cols; }

	TileSet* tileSet() { return m_tileSet; }

	bool copyData(const QRect& area, int layer, const MapDocument& source,
	              const QPoint& destpoint, bool createlayer = true,
	              bool allowresize = true);


	void setSelectionArea(const QRect& area) {
		m_selectionArea = area;
	}

	QRect selectionArea() const {
		return m_selectionArea;
	}

private:
	void clearModifies();
	
private:
	QString m_fileName;
	uchar m_fileVersion;

	bool m_modified;

	int m_rows;
	int m_cols;

	TileSet* m_tileSet;

	QPtrList<MapLayer> m_layers;
	uint m_currentLayerIndex;

	QPixmap* m_cachePix;

	QRect m_selectionArea;
};

#endif

// End of file
