#include <cstring>
#include <string>

#include "Configuration.h"

#include "SoundFactory.h"


//----------------------------------------------------------------------------
SoundFactory *SoundFactory::sm_instance = NULL;


//----------------------------------------------------------------------------
SoundFactory::SoundFactory()
{
    memset(m_chunks, 0, sizeof(m_chunks));
}

//----------------------------------------------------------------------------
SoundFactory::~SoundFactory()
{
    for (int i = 0; i < S_TOTAL_NUMBER; i++)
    {
        ZAP_CHUNK(m_chunks[i]);
    }
}

//----------------------------------------------------------------------------
void SoundFactory::init()
{
    static const char *file[] =
    {
        "bump1.wav",
        "cash1.wav",
        "ding1.wav",
        "explosion1.wav",
        "explosion2.wav",
        "explosion3.wav",
        "sweep1.wav",
        "thrust1.wav",
        "warp1.wav",
        "zap1.wav",
        "zap2.wav"
    };

    sm_instance = new SoundFactory();

    for (int i = 0; i < S_TOTAL_NUMBER; i++)
    {
        std::string path;
        path.append(Configuration::getInstance()->getDataDir())
            .append("/sound/fx/").append(file[i]);
        sm_instance->m_chunks[i] = SDL_MIXER_CALLS::LoadWAV(path.c_str());
    }
}

//----------------------------------------------------------------------------
void SoundFactory::destroy()
{
    ZAP_POINTER(sm_instance);
}
