#include "File.h"
#include "Configuration.h"
#include "GameControlBase.h"
#include "PlayerConfiguration.h"

#include "SinglePlayerGame.h"


//----------------------------------------------------------------------------
SinglePlayerGame *SinglePlayerGame::sm_instance = NULL;


//----------------------------------------------------------------------------
SinglePlayerGame::SinglePlayerGame(const char *mission, unsigned level)
        : m_mission(mission)
{
    m_levelReader.init(mission);
    m_levelIter = m_levelReader.begin();

    for (; level>1; level--) ++m_levelIter;
}

//----------------------------------------------------------------------------
SinglePlayerGame::~SinglePlayerGame()
{
}


//----------------------------------------------------------------------------
void SinglePlayerGame::init(const char *mission, unsigned level)
{
    sm_instance = new SinglePlayerGame(mission, level);
}

//----------------------------------------------------------------------------
void SinglePlayerGame::destroy()
{
    ZAP_POINTER(sm_instance);
}


//----------------------------------------------------------------------------
bool SinglePlayerGame::hasMoreLevels() const
{
    LevelReader::const_iterator iter(m_levelIter);
    return std::distance(iter, m_levelReader.end()) > 1;
}

//----------------------------------------------------------------------------
void SinglePlayerGame::nextLevel()
{
    PlayerConfiguration::getInstance()->getMission()->updateLastPlayed(
        m_levelReader.getMission(),
        std::distance(m_levelReader.begin(), ++m_levelIter) + 1);
}
