#ifndef GAMEPLAYER_H
#define GAMEPLAYER_H

#include <map>
#include <vector>

#include "Tools.h"
#include "File.h"
#include "PDUs.h"


//----------------------------------------------------------------------------
class GamePlayer
{
    SINGLETON_OBJECT(GamePlayer);

    //------------------------------------------------------------------------
    typedef std::map<Uint16, ObjectPDUBase*> ObjectPDUs;
    typedef std::vector<Uint16> ObjectIds;

    //------------------------------------------------------------------------
    class CreateObjectPDUVisitor : public PDUVisitor
    {
      public:
        //--------------------------------------------------------------------
        CreateObjectPDUVisitor(File *file) : m_file(file) {}
        ~CreateObjectPDUVisitor() { m_file = NULL; }

      private:
        //--------------------------------------------------------------------
        void do_visit(BarrierPDU *pdu);
        void do_visit(BlackHolePDU *pdu);
        void do_visit(CratePDU *pdu);
        void do_visit(GrenadePDU *pdu);
        void do_visit(GrinderPDU *pdu);
        void do_visit(MagnetBasePDU *pdu);
        void do_visit(MissilePDU *pdu);
        void do_visit(MortarBasePDU *pdu);
        void do_visit(ParticleFountainBasePDU *pdu);
        void do_visit(PlatformPDU *pdu);
        void do_visit(ProjectileBasePDU *pdu);
        void do_visit(SAMBatteryBasePDU *pdu);
        void do_visit(ShipPDU *pdu);
        void do_visit(SwitchBasePDU *pdu);
        void do_visit(TankPDU *pdu);
        void do_visit(ThornPDU *pdu);
        void do_visit(TurretBasePDU *pdu);

        //--------------------------------------------------------------------
        void do_visit(HeaderPDU *pdu);
        void do_visit(DeleteObjectPDU *pdu);

        //--------------------------------------------------------------------
        void do_objectPDUBase(ObjectPDUBase *pdu);
        void do_staticDecorationObjectPDUBase(StaticDecorationObjectPDUBase *pdu);

        //--------------------------------------------------------------------
        File *m_file;
    };

    //------------------------------------------------------------------------
    class UpdateObjectPDUVisitor : public PDUVisitor
    {
      public:
        //--------------------------------------------------------------------
        UpdateObjectPDUVisitor(File *file) : m_file(file) {}
        ~UpdateObjectPDUVisitor() { m_file = NULL; }

      private:
        //--------------------------------------------------------------------
        void do_visit(BarrierPDU *pdu);
        void do_visit(BlackHolePDU *pdu);
        void do_visit(CratePDU *pdu);
        void do_visit(GrenadePDU *pdu);
        void do_visit(GrinderPDU *pdu);
        void do_visit(MagnetBasePDU *pdu);
        void do_visit(MissilePDU *pdu);
        void do_visit(MortarBasePDU *pdu);
        void do_visit(ParticleFountainBasePDU *pdu);
        void do_visit(PlatformPDU *pdu);
        void do_visit(ProjectileBasePDU *pdu);
        void do_visit(SAMBatteryBasePDU *pdu);
        void do_visit(ShipPDU *pdu);
        void do_visit(SwitchBasePDU *pdu);
        void do_visit(TankPDU *pdu);
        void do_visit(ThornPDU *pdu);
        void do_visit(TurretBasePDU *pdu);

        //--------------------------------------------------------------------
        void do_visit(HeaderPDU *pdu);
        void do_visit(DeleteObjectPDU *pdu);

        //--------------------------------------------------------------------
        File *m_file;
    };


    //------------------------------------------------------------------------
    class CreateGameObjectPDUVisitor : public PDUVisitor
    {
      public:
        //--------------------------------------------------------------------
        CreateGameObjectPDUVisitor() {}
        ~CreateGameObjectPDUVisitor() {}

      private:
        //--------------------------------------------------------------------
        void do_visit(BarrierPDU *pdu);
        void do_visit(BlackHolePDU *pdu);
        void do_visit(CratePDU *pdu);
        void do_visit(GrenadePDU *pdu);
        void do_visit(GrinderPDU *pdu);
        void do_visit(MagnetBasePDU *pdu);
        void do_visit(MissilePDU *pdu);
        void do_visit(MortarBasePDU *pdu);
        void do_visit(ParticleFountainBasePDU *pdu);
        void do_visit(PlatformPDU *pdu);
        void do_visit(ProjectileBasePDU *pdu);
        void do_visit(SAMBatteryBasePDU *pdu);
        void do_visit(ShipPDU *pdu);
        void do_visit(SwitchBasePDU *pdu);
        void do_visit(TankPDU *pdu);
        void do_visit(ThornPDU *pdu);
        void do_visit(TurretBasePDU *pdu);

        //--------------------------------------------------------------------
        void do_visit(HeaderPDU *pdu);
        void do_visit(DeleteObjectPDU *pdu);
    };

    //------------------------------------------------------------------------
    class UpdateGameObjectPDUVisitor : public PDUVisitor
    {
      public:
        //--------------------------------------------------------------------
        UpdateGameObjectPDUVisitor() {}
        ~UpdateGameObjectPDUVisitor() {}

      private:
        //--------------------------------------------------------------------
        void do_visit(BarrierPDU *pdu);
        void do_visit(BlackHolePDU *pdu);
        void do_visit(CratePDU *pdu);
        void do_visit(GrenadePDU *pdu);
        void do_visit(GrinderPDU *pdu);
        void do_visit(MagnetBasePDU *pdu);
        void do_visit(MissilePDU *pdu);
        void do_visit(MortarBasePDU *pdu);
        void do_visit(ParticleFountainBasePDU *pdu);
        void do_visit(PlatformPDU *pdu);
        void do_visit(ProjectileBasePDU *pdu);
        void do_visit(SAMBatteryBasePDU *pdu);
        void do_visit(ShipPDU *pdu);
        void do_visit(SwitchBasePDU *pdu);
        void do_visit(TankPDU *pdu);
        void do_visit(ThornPDU *pdu);
        void do_visit(TurretBasePDU *pdu);

        //--------------------------------------------------------------------
        void do_visit(HeaderPDU *pdu);
        void do_visit(DeleteObjectPDU *pdu);
    };

  public:
    //------------------------------------------------------------------------
    GamePlayer();
    ~GamePlayer();

    //------------------------------------------------------------------------
    void readFrame();

  private:
    //------------------------------------------------------------------------
    void readPDU();
    void processPDUs();

    //------------------------------------------------------------------------
    ObjectPDUBase *createObjectPDU(const PDUBase::Ids id);

    //------------------------------------------------------------------------
    File *m_file;

    //------------------------------------------------------------------------
    ObjectPDUs m_createdPDUs;
    ObjectPDUs m_activePDUs;
    ObjectIds m_objectIdsToDelete;
};

#endif //GAMEPLAYER_H
