/* mg-db-field.h
 *
 * Copyright (C) 2003 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */


#ifndef __MG_DB_FIELD_H_
#define __MG_DB_FIELD_H_

#include "mg-base.h"
#include "mg-defs.h"
#include <libgda/libgda.h>

G_BEGIN_DECLS

#define MG_DB_FIELD_TYPE          (mg_db_field_get_type())
#define MG_DB_FIELD(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, mg_db_field_get_type(), MgDbField)
#define MG_DB_FIELD_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, mg_db_field_get_type (), MgDbFieldClass)
#define IS_MG_DB_FIELD(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, mg_db_field_get_type ())


/* error reporting */
extern GQuark mg_db_field_error_quark (void);
#define MG_DB_FIELD_ERROR mg_db_field_error_quark ()

enum
{
	MG_DB_FIELD_XML_LOAD_ERROR
};


/* struct for the object's data */
struct _MgDbField
{
	MgBase                  object;
	MgDbFieldPrivate       *priv;
};

/* struct for the object's class */
struct _MgDbFieldClass
{
	MgBaseClass                    class;

	/* signals */
	void   (*templ_signal)        (MgDbField *obj);
};

guint           mg_db_field_get_type          (void);
GObject        *mg_db_field_new               (MgConf *conf, MgServerDataType *type);

void            mg_db_field_set_length        (MgDbField *field, gint length);
gint            mg_db_field_get_length        (MgDbField *field);
void            mg_db_field_set_scale         (MgDbField *field, gint length);
gint            mg_db_field_get_scale         (MgDbField *field);
GSList         *mg_db_field_get_constraints   (MgDbField *field);
void            mg_db_field_set_data_type     (MgDbField *field, MgServerDataType *type);
void            mg_db_field_set_default_value (MgDbField *field, const GdaValue *value);
const GdaValue *mg_db_field_get_default_value (MgDbField *field);
gboolean        mg_db_field_is_null_allowed   (MgDbField *field);
gboolean        mg_db_field_is_pkey_part      (MgDbField *field);
gboolean        mg_db_field_is_pkey_alone     (MgDbField *field);
gboolean        mg_db_field_is_fkey_part      (MgDbField *field);
gboolean        mg_db_field_is_fkey_alone     (MgDbField *field);

G_END_DECLS

#endif
