//   -*- mode: c++; -*-
#include <map.h>
#include <multimap.h>
#include <vector.h>
#include "adstring.h"
#include "common.h"

//Exception classes:

class unknown_cond_package:public except_pi_String{
public:
  unknown_cond_package(parsestream *p, String s):except_pi_String(p,s){};
  String message(){
    return Sprintf(_("Unknown install condition \"%s\" (currently, only \"package\" is supported)"),msg);
  };
};  
class def_error:public except_pi_String{
public:
  def_error(parsestream *p, String s):except_pi_String(p,s){};
  String message(){
    return Sprintf(_("Error in definition: %s"),msg);
  };
};  

class cond_inst_false: public genexcept{};//conditional install returns false

class ferror_read: public except_String{
public:
  ferror_read(String s):except_String(s){};
  String message(){
    return Sprintf(_("Could not open \"%s\" for reading"),msg);
  };
};  //file open for reading failed
class pipeerror_read: public except_String{
public:
  pipeerror_read(String s):except_String(s){};
  String message(){
    return Sprintf(_("Failed to pipe data through \"%s\" (pipe opened for reading)"),msg);
  };
};  //pipe open for reading failed

class dir_error_read{
public:
  char name[MAX_LINE];
  dir_error_read(String s){
    strcpy(name,s.c_str());
  };
};  //dir open for reading failed

class informed_fatal: public genexcept{}; //something BAD happened, we told user, now die.


#define CONFIGMENUS     "/etc/menu/"
#define PACKAGEMENUS    "/usr/lib/menu/"
#define MENUMENUS       "/usr/lib/menu/default/"
#define USERMENUS       ".menu/"
#define USERMETHODS     ".menu-methods/"

#define MENU1_INSTALLER "#!/usr/sbin/install-menu"

#define UPMEN_LOCKFILE  "/var/run/update-menus.pid"
#define DPKG_LOCKFILE   "/var/lib/dpkg/lock"
#define TRANSLATE_FILE  "/etc/menu-methods/translate_menus"
#define USERTRANSLATE   ".menu-methods/translate_menus"
#define CONFIG_FILE     "/etc/menu-methods/menu.config"
#define USERCONFIG      ".menu-methods/menu.config"


#define TRANSLATE_TRANS    "translate"
#define SUBSTITUTE_TRANS   "substitute"
#define SUBTRANSLATE_TRANS "subtranslate"
#define ENDTRANSLATE_TRANS "endtranslate"
class menuentry {
private:
  bool test_installed(String filename);
  bool check_install(parsestream &i, String &);
  void  menuentry_constr_gccbug(parsestream &i);
public:
  map <String, String, less<String> > data;
  menuentry(parsestream &i, const String &);
  void output(vector<String> &s);
  ostream &debugoutput(ostream &o);
};



class trans_class{
protected:
  String match, replace, replace_var;
public:
  bool check(String &s);
  trans_class(const String &m,
	      const String &r,
	      const String &rv);
  
  virtual void process(menuentry &m,
		       const String &v)=NULL;
  String debuginfo();
  virtual ~trans_class();
};
class translate: public trans_class{
public:
  translate(const String &m,
	    const String &r,
	    const String &rv):trans_class(m,r,rv){};
  
  void process(menuentry &m,
	       const String &v);
};
class substitute: public trans_class{
public:
  substitute(const String &m,
	    const String &r,
	    const String &rv):trans_class(m,r,rv){};

  void process(menuentry &m,
	       const String &v);
};
class subtranslate: public trans_class{
public:
  subtranslate( String &m,
	    const String &r,
	    const String &rv):trans_class(m,r,rv){};

  void process(menuentry &m,
	       const String &v);
};

class translateinfo{
  typedef multimap<String, trans_class*, less<String> > trans_map;
  map<String, trans_map, less<String> > trans;
  //  map<String, multimap<String, trans_class*, less<String> >, less<String> > trans;
  void init(parsestream &i);
public:
  translateinfo(parsestream &i);
  translateinfo(const String &filename);
  void process(menuentry &m);
  void debuginfo();
};

class configinfo{
public:
  typedef enum {report_quiet,report_normal,report_verbose,report_debug} 
  verbosity_type;
  parsestream::eol_type compat;
  StrVec menufilesdir;
  String menumethod;
  bool usedefaultmenufilesdirs;

private:
  typedef enum {method_stdout,method_stderr,method_syslog}
  method_type;

  
private:
  verbosity_type verbosity;
  method_type method;
  int syslog_facility, syslog_priority;
  void parse_def(const String &var, parsestream &p);
public:

  configinfo();
  void update(String filename);
  void report(const String &message,verbosity_type v);
  void set_verbosity(verbosity_type v){verbosity=v;};  
};




