/* signal.c -- signals handling
 *
 * Copyright(C) 2001-2002 Elisa Manara <e@entropika.net>
 * This code is released under the GPL License version 2 */


#include <gtk/gtk.h>
#include <signal.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include "melon.h"
#include "def.h"

volatile sig_atomic_t end_signal = 0;
volatile sig_atomic_t open_signal = 0;
volatile sig_atomic_t reset_signal = 0;

extern int ignore_pid;

void melon_signals_connect(void);
int melon_error(const char *fmt, ...);
void set_pid_file(char *pid_file_path);
pid_t check_pid(void);
void unset_all (GtkWidget *widget, gpointer data);
gint see_mail (GtkWidget *widget, char *mbox);
void melon_end(void);

gint melon_handle_signals(gpointer data)
{
	if(end_signal) {
		/* TODO: esce sempre con 0??? */
		melon_end();
		exit(0);
	}

	if(open_signal) {
		if (cfg_data.mbox[1][0] == '\0' || none_active_mbox())
			see_mail(NULL, NULL);
		else
			see_mail(NULL, active_mbox[0]);

		open_signal = 0;
	}

	if(reset_signal) {
		unset_all(NULL, NULL);
		reset_signal = 0;
	}

	return 1;
}
	
void sig_handler(int signum)
{
	switch(signum) {
	case SIGINT:
	case SIGQUIT:
	case SIGILL:
	case SIGSEGV:
	case SIGPIPE:
	case SIGTERM:
	case SIGSTOP:
		end_signal++;
		break;
	case SIGUSR1:
		open_signal++;
		break;
	case SIGUSR2:
		reset_signal++;
		break;
	case SIGHUP:
		break;
	default:
	}
}

void melon_signals_connect(void)
{
	signal(SIGHUP,  sig_handler);
	signal(SIGINT,  sig_handler);
	signal(SIGQUIT, sig_handler);
	signal(SIGILL,  sig_handler);
	signal(SIGSEGV, sig_handler);
	signal(SIGPIPE, sig_handler);
	signal(SIGTERM, sig_handler);
	signal(SIGSTOP, sig_handler);
	signal(SIGUSR1, sig_handler);
	signal(SIGUSR2, sig_handler);
}

void melon_init_control(int argc, char **argv) 
{
	pid_t running_pid;
	char action_c[16];

	action_c[0] = '\0';

	running_pid=check_pid();
	if(running_pid < 0) {
		melon_error("Pid error");
		exit(1);
	}
	if(running_pid == 0)
		/* no other melon is running */
		return;

	/* an other melon is running.
	 * We check if there is a good reason
	 * for calling it ;)
	 */
	if(argc > 1) {
		if((strcmp(argv[1], "open")) == 0) {
			kill(running_pid, SIGUSR1);
			exit(0);
		} else if ((strcmp(argv[1], "reset")) == 0) {
			kill(running_pid, SIGUSR2);
			exit(0);
		} else if ((strcmp(argv[1], "stop")) == 0) {
			kill(running_pid, SIGINT);
			exit(0);
		}
	}

	fprintf(stderr, "A melon pid file was found. Maybe another melon "
		"is already running. \n");
	fprintf(stderr, "(I)gnore, (O)verwrite, (Q)uit? ");
	fflush(stderr);
	while(fgets(action_c, 16, stdin)) {
		//printf("action: %s\n", action_c);
		switch(action_c[0]) {
		case 'i':
		case 'I':
			ignore_pid = 1;
			return;
		case 'o':
		case 'O':
			return;
		case 'q':
		case 'Q':
			exit(0);
		default:
			fprintf(stderr, "(I)gnore, (O)verwrite, (Q)uit? ");
			fflush(stderr);
		}
	}
}


