""" A view containing the contents of a Python shell namespace. """


# Enthought library imports.
from enthought.envisage.workbench import View
from enthought.traits.api import HasTraits, Str, Property
from enthought.traits.ui.api import Item, TableEditor, VGroup, View as TraitsView
from enthought.traits.ui.table_column import ListColumn, ObjectColumn
from enthought.traits.ui.table_filter \
    import TableFilter, RuleTableFilter, RuleFilterTemplate, \
           MenuFilterTemplate, EvalFilterTemplate

# Plugin definition imports.
from enthought.plugins.python_shell.python_shell_plugin_definition import \
     Namespace


# Table editor definition:  
filters      = [ EvalFilterTemplate, MenuFilterTemplate, RuleFilterTemplate ]

table_editor = TableEditor(
    columns     = [
        ObjectColumn(name='name'),
        ObjectColumn(name='type')
    ],
    editable    = False,
    deletable   = False,
    sortable    = True,
    sort_model  = False,
    filters     = filters,
    search      = RuleTableFilter(),
    #row_factory = Person
)

## table_editor = TableEditor(
##     columns     = [
##         ListColumn(label='Name', index=0),
##         ListColumn(label='Type', index=1)
##     ],
    
##     editable    = False,
##     deletable   = False,
##     sortable    = True,
##     sort_model  = False,
##     filters     = []
## )
    
class NamespaceView(View):
    """ A view containing the contents of the Python shell namespace. """

    #### 'NamespaceView' interface ############################################

    # The bindings in the namespace.
    bindings = Property

    # The default traits UI view.
    traits_view = TraitsView(
        VGroup(
            Item(
                'bindings',
                id     = 'table',
                editor = table_editor
            ),

            show_border = True,
            show_labels = False
        )
    )

    ###########################################################################
    # 'View' interface.
    ###########################################################################

    def create_control(self, parent):
        """ Creates the toolkit-specific control that represents the view.

        'parent' is the toolkit-specific control that is the view's parent.

        """

        self.ui = self.edit_traits(parent=parent, kind='subpanel')

        # fixme: We have a race condition here - we can't guarantee that the
        # the Python shell view before this one! Should we really create a new
        # plugin and make if require this one? Will that help? Since the Python
        # shell service is only created when its view is created! We need the
        # notion of service dependency and the ability for things to happen
        # when a service appears or disappears!
        shell = self.get_service('enthought.plugins.IPythonShell')
        shell.on_trait_change(self._on_names_changed, 'names')
        
        return self.ui.control

    ###########################################################################
    # 'NamespaceView' interface.
    ###########################################################################

    #### Properties ###########################################################

    def _get_bindings(self):
        """ Property getter. """
        
        shell = self.get_service('enthought.plugins.IPythonShell')

        # fixme: We should be able to use a list of lists instead of having
        # to create these objects!
        class item(HasTraits):
            name = Str
            type = Str

        data = [
            item(name=name, type=str(type(shell.lookup(name))))
            for name in shell.names
        ]

##         data = [
##             (name=name, str(type(shell.lookup(name))))  for name in shell.names
##         ]
        
        return data
    
    ###########################################################################
    # Private interface.
    ###########################################################################

    #### Trait change handlers ################################################
    
    def _on_names_changed(self, new):
        """ Dynamic trait change handler. """

        # fixme: We might want to get a tad more granular in the event that we
        # fire!
        self.trait_property_changed('bindings', [], self.bindings)
        
        return
    
#### EOF ######################################################################
