import sys
import os
from os import path

from pkg_resources import require

if sys.platform == 'win32':
    # by importing wininst functions into the builtin module,
    # post install scripts which check if they are being ran
    # from a wininst installer will now execute as if they were
    # installed via the wininst installer
    try:
        import wininst.wininst as wininst
        from wininst.common import get_enthought_start_menu
        
        et_menu = get_enthought_start_menu()
        
        if not path.isdir(et_menu):
            os.mkdir(et_menu)
        
        # fixme: Make this part of the API for installation.
        package_dir = path.dirname(
                 path.dirname(
                    path.dirname( 
                       path.abspath( __file__ ) ) ) )

        icon_path = path.join(package_dir, "enthought", "mayavi", "images", "m2.ico")
        mayavi_link = path.join(et_menu, 'MayaVi.lnk')
        executable = path.join(sys.prefix, "Scripts", "mayavi2.exe")
        wininst.create_shortcut(executable,
                                'The MayaVi scientific data visualizer',
                                mayavi_link,
                                "","",
                                icon_path)

    except ImportError:
        print "WARNING: wininst module not found, some installs may not be complete"
    
