""" The plugin's main preference page. """


# Enthought library imports.
from enthought.envisage.ui import UIPlugin
from enthought.traits.api import Bool
from enthought.traits.ui.api import View, Group, Item

# Local imports.
from workbench_preference_page import WorkbenchPreferencePage
from enthought.envisage.ui.ui_plugin import UIPlugin

class UIPreferencePage(WorkbenchPreferencePage):
    """ The plugin's main preference page. """

    # Should we prompt the user before exiting the application?
    prompt_on_exit = Bool

    # Should we display the name of each tool bar tool under its image?
    show_tool_names = Bool

    # The default view.
    traits_view = View(
        Group(
            Item(name='prompt_on_exit'),
            Item(name='show_tool_names'),
            show_border=False, show_left=False
        ),
    )

    def restore_defaults(self):
        super(UIPreferencePage, self).restore_defaults()
        
        # update the properties so the view gets updated
        self.prompt_on_exit = UIPlugin.instance.preferences.get('prompt_on_exit')
        self.show_tool_names = UIPlugin.instance.preferences.get('show_tool_names')

    ###########################################################################
    # Protected 'WorkbenchPreferencePage' interface.
    ###########################################################################

    def _get_preferences(self):
        """ Returns the preferences that this page is editing. """

        return UIPlugin.instance.preferences
    
#### EOF ######################################################################
