#-----------------------------------------------------------------------------
#
#  Copyright (c) 2006-2007 by Enthought, Inc.
#  All rights reserved.
#
#-----------------------------------------------------------------------------

"""
The default UI service factory.

"""


# Enthought library imports.
from enthought.traits.api import HasTraits

# Local imports.
from ui_service import UiService


class UIServiceFactory(HasTraits):
    """
    The default UI service factory.

    """


    ###########################################################################
    # 'UIServiceFactory' interface.
    ###########################################################################

    def create_ui_service(self, *args, **kw):
        """ Create the UI service. """

        return UiService(*args, **kw)


#### EOF ######################################################################
