#-----------------------------------------------------------------------------
#
#  Copyright (c) 2005-2007 by Enthought, Inc.
#  All rights reserved.
#
#  Author: Dave Peterson <dpeterson@enthought.com>
#
#-----------------------------------------------------------------------------

"""
The resource type for our project resources.

"""

# Enthought library imports
from enthought.envisage.resource import ResourceType
from enthought.traits.api import Instance

# Local imports.
from project_node_type import ProjectNodeType


class ProjectResourceType(ResourceType):
    """
    The resource type for our project resources.

    """

    ##########################################################################
    # Traits
    ##########################################################################

    #### public 'ResourceType' interface #####################################

    # A trait that describes the kind of domain object that the type
    # represents.
    type = Instance('enthought.envisage.single_project.project.Project')


    ##########################################################################
    # 'ResourceType' interface.
    ##########################################################################

    #### Initializers ########################################################

    def _node_type_default(self):
        """
        Initializes the node type.

        """

        return ProjectNodeType(resource_type=self)


#### EOF #####################################################################
