""" The base class for all resource node monitors. """


# Enthought library imports.
from enthought.pyface.tree.api import NodeMonitor


class ResourceNodeMonitor(NodeMonitor):
    """ The base class for all resource node monitors. """

    ###########################################################################
    # 'ResourceNodeMonitor' interface.
    ###########################################################################

    #### Trait event handlers #################################################

    def name_changed(self, obj, trait_name, old, new):
        """ Called when the name of the resource has changed. """

        if old in self.node.context.list_names():
            self.node.context.rename(old, new)
            
        self.node.name = new
        
        return

#### EOF ######################################################################
